/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEEncrypterMulti;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.UnprotectedHeader;
import com.nimbusds.jose.crypto.impl.ECDH1PU;
import com.nimbusds.jose.crypto.impl.ECDH1PUCryptoProvider;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.jwk.gen.OctetKeyPairGenerator;
import com.nimbusds.jose.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ECDH1PUX25519EncrypterMulti
extends ECDH1PUCryptoProvider
implements JWEEncrypterMulti {
    public static final Set<Curve> SUPPORTED_ELLIPTIC_CURVES;
    private final OctetKeyPair sender;
    private final List<Pair<UnprotectedHeader, OctetKeyPair>> recipients;

    public ECDH1PUX25519EncrypterMulti(OctetKeyPair sender, List<Pair<UnprotectedHeader, OctetKeyPair>> recipients) throws JOSEException {
        super(sender.getCurve());
        this.sender = sender;
        this.recipients = recipients;
    }

    @Override
    public Set<Curve> supportedEllipticCurves() {
        return SUPPORTED_ELLIPTIC_CURVES;
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        OctetKeyPair ephemeralPrivateKey = new OctetKeyPairGenerator(this.getCurve()).generate();
        OctetKeyPair ephemeralPublicKey = ephemeralPrivateKey.toPublicJWK();
        JWEHeader updatedHeader = new JWEHeader.Builder(header).ephemeralPublicKey(ephemeralPublicKey).build();
        ArrayList<Pair<UnprotectedHeader, SecretKey>> sharedKeys = new ArrayList<Pair<UnprotectedHeader, SecretKey>>();
        for (Pair<UnprotectedHeader, OctetKeyPair> recipient : this.recipients) {
            SecretKey Z = ECDH1PU.deriveSenderZ(this.sender, recipient.getRight().toPublicJWK(), ephemeralPrivateKey);
            sharedKeys.add(Pair.of(recipient.getLeft(), Z));
        }
        return this.encryptMulti(updatedHeader, sharedKeys, clearText);
    }

    static {
        LinkedHashSet<Curve> curves = new LinkedHashSet<Curve>();
        curves.add(Curve.X25519);
        SUPPORTED_ELLIPTIC_CURVES = Collections.unmodifiableSet(curves);
    }
}

