/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64URL;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class ThumbprintURI {
    public static final String PREFIX = "urn:ietf:params:oauth:jwk-thumbprint:";
    private final Base64URL thumbprint;

    public ThumbprintURI(Base64URL thumbprint) {
        if (thumbprint == null) {
            throw new IllegalArgumentException("The thumbprint must not be null");
        }
        this.thumbprint = thumbprint;
    }

    public Base64URL getThumbprint() {
        return this.thumbprint;
    }

    public URI toURI() {
        return URI.create(PREFIX + this.thumbprint);
    }

    public String toString() {
        return PREFIX + this.thumbprint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThumbprintURI)) {
            return false;
        }
        ThumbprintURI that = (ThumbprintURI)o;
        return this.getThumbprint().equals(that.getThumbprint());
    }

    public int hashCode() {
        return Objects.hash(this.getThumbprint());
    }

    public static ThumbprintURI compute(JWK jwk) throws JOSEException {
        return new ThumbprintURI(jwk.computeThumbprint());
    }

    public static ThumbprintURI parse(URI uri) throws ParseException {
        String uriString = uri.toString();
        if (!uriString.startsWith(PREFIX)) {
            throw new ParseException("Illegal JWK thumbprint prefix", 0);
        }
        String thumbprintValue = uriString.substring(PREFIX.length());
        if (thumbprintValue.isEmpty()) {
            throw new ParseException("Illegal JWK thumbprint: Empty value", 0);
        }
        return new ThumbprintURI(new Base64URL(thumbprintValue));
    }

    public static ThumbprintURI parse(String s) throws ParseException {
        try {
            return ThumbprintURI.parse(new URI(s));
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }
}

