/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationErrorResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.OIDCError;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public class AuthenticationErrorResponse
extends AuthorizationErrorResponse
implements AuthenticationResponse {
    private static final Set<ErrorObject> stdErrors = new HashSet<ErrorObject>();

    public static Set<ErrorObject> getStandardErrors() {
        return Collections.unmodifiableSet(stdErrors);
    }

    public AuthenticationErrorResponse(URI redirectURI, ErrorObject error, State state, ResponseMode rm) {
        super(redirectURI, error, state, rm);
    }

    @Override
    public AuthenticationSuccessResponse toSuccessResponse() {
        throw new ClassCastException("Cannot cast to AuthenticationSuccessResponse");
    }

    @Override
    public AuthenticationErrorResponse toErrorResponse() {
        return this;
    }

    public static AuthenticationErrorResponse parse(URI redirectURI, Map<String, String> params) throws ParseException {
        AuthorizationErrorResponse resp = AuthorizationErrorResponse.parse(redirectURI, params);
        return new AuthenticationErrorResponse(resp.getRedirectionURI(), resp.getErrorObject(), resp.getState(), null);
    }

    public static AuthenticationErrorResponse parse(URI uri) throws ParseException {
        AuthorizationErrorResponse resp = AuthorizationErrorResponse.parse(uri);
        return new AuthenticationErrorResponse(resp.getRedirectionURI(), resp.getErrorObject(), resp.getState(), null);
    }

    public static AuthenticationErrorResponse parse(HTTPResponse httpResponse) throws ParseException {
        AuthorizationErrorResponse resp = AuthorizationErrorResponse.parse(httpResponse);
        return new AuthenticationErrorResponse(resp.getRedirectionURI(), resp.getErrorObject(), resp.getState(), null);
    }

    public static AuthenticationErrorResponse parse(HTTPRequest httpRequest) throws ParseException {
        URI baseURI;
        try {
            baseURI = httpRequest.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), e);
        }
        if (httpRequest.getQuery() != null) {
            return AuthenticationErrorResponse.parse(baseURI, URLUtils.parseParameters(httpRequest.getQuery()));
        }
        if (httpRequest.getFragment() != null) {
            return AuthenticationErrorResponse.parse(baseURI, URLUtils.parseParameters(httpRequest.getFragment()));
        }
        throw new ParseException("Missing URI fragment, query string or post body");
    }

    static {
        stdErrors.addAll(AuthorizationErrorResponse.getStandardErrors());
        stdErrors.add(OIDCError.INTERACTION_REQUIRED);
        stdErrors.add(OIDCError.LOGIN_REQUIRED);
        stdErrors.add(OIDCError.ACCOUNT_SELECTION_REQUIRED);
        stdErrors.add(OIDCError.CONSENT_REQUIRED);
        stdErrors.add(OIDCError.INVALID_REQUEST_URI);
        stdErrors.add(OIDCError.INVALID_REQUEST_OBJECT);
        stdErrors.add(OIDCError.REGISTRATION_NOT_SUPPORTED);
        stdErrors.add(OIDCError.REQUEST_NOT_SUPPORTED);
        stdErrors.add(OIDCError.REQUEST_URI_NOT_SUPPORTED);
    }
}

