/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.claims;

import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.SessionID;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minidev.json.JSONObject;

abstract class CommonClaimsSet
extends ClaimsSet {
    public static final String ISS_CLAIM_NAME = "iss";
    public static final String SUB_CLAIM_NAME = "sub";
    public static final String AUD_CLAIM_NAME = "aud";
    public static final String IAT_CLAIM_NAME = "iat";
    public static final String SID_CLAIM_NAME = "sid";

    protected CommonClaimsSet() {
    }

    protected CommonClaimsSet(JSONObject jsonObject) {
        super(jsonObject);
    }

    public Issuer getIssuer() {
        String val = this.getStringClaim(ISS_CLAIM_NAME);
        return val != null ? new Issuer(val) : null;
    }

    public Subject getSubject() {
        String val = this.getStringClaim(SUB_CLAIM_NAME);
        return val != null ? new Subject(val) : null;
    }

    public List<Audience> getAudience() {
        if (this.getClaim(AUD_CLAIM_NAME) instanceof String) {
            return new Audience(this.getStringClaim(AUD_CLAIM_NAME)).toSingleAudienceList();
        }
        List<String> rawList = this.getStringListClaim(AUD_CLAIM_NAME);
        if (rawList == null) {
            return null;
        }
        ArrayList<Audience> audList = new ArrayList<Audience>(rawList.size());
        for (String s : rawList) {
            audList.add(new Audience(s));
        }
        return audList;
    }

    public Date getIssueTime() {
        return this.getDateClaim(IAT_CLAIM_NAME);
    }

    public SessionID getSessionID() {
        String val = this.getStringClaim(SID_CLAIM_NAME);
        return val != null ? new SessionID(val) : null;
    }

    public void setSessionID(SessionID sid) {
        this.setClaim(SID_CLAIM_NAME, sid != null ? sid.getValue() : null);
    }
}

