/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.SchemaParser;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPMatchingRuleSchema
extends LDAPSchemaElement {
    private String syntaxString;
    private String[] attributes;

    public LDAPMatchingRuleSchema() {
        super(LDAPSchema.schemaTypeNames[6]);
    }

    public LDAPMatchingRuleSchema(String[] names, String oid, String description, String[] attributes, boolean obsolete, String syntaxString) {
        super(LDAPSchema.schemaTypeNames[6]);
        this.names = (String[])names.clone();
        this.oid = oid;
        this.description = description;
        this.obsolete = obsolete;
        this.attributes = (String[])attributes.clone();
        this.syntaxString = syntaxString;
        super.setValue(this.formatString());
    }

    public LDAPMatchingRuleSchema(String rawMatchingRule, String rawMatchingRuleUse) {
        super(LDAPSchema.schemaTypeNames[6]);
        try {
            SchemaParser matchParser = new SchemaParser(rawMatchingRule);
            this.names = (String[])matchParser.getNames().clone();
            this.oid = matchParser.getID();
            this.description = matchParser.getDescription();
            this.obsolete = matchParser.getObsolete();
            this.syntaxString = matchParser.getSyntax();
            if (rawMatchingRuleUse != null) {
                SchemaParser matchUseParser = new SchemaParser(rawMatchingRuleUse);
                this.attributes = matchUseParser.getApplies();
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public String getSyntaxString() {
        return this.syntaxString;
    }

    protected String formatString() {
        String[] strArray;
        StringBuffer valueBuffer = new StringBuffer("( ");
        String token = this.getID();
        if (token != null) {
            valueBuffer.append(token);
        }
        if ((strArray = this.getNames()) != null) {
            valueBuffer.append(" NAME ");
            if (strArray.length == 1) {
                valueBuffer.append("'" + strArray[0] + "'");
            } else {
                valueBuffer.append("( ");
                for (int i = 0; i < strArray.length; ++i) {
                    valueBuffer.append(" '" + strArray[i] + "'");
                }
                valueBuffer.append(" )");
            }
        }
        if ((token = this.getDescription()) != null) {
            valueBuffer.append(" DESC ");
            valueBuffer.append("'" + token + "'");
        }
        if (this.isObsolete()) {
            valueBuffer.append(" OBSOLETE");
        }
        if ((token = this.getSyntaxString()) != null) {
            valueBuffer.append(" SYNTAX ");
            valueBuffer.append(token);
        }
        valueBuffer.append(" )");
        return valueBuffer.toString();
    }

    protected void setDeserializedValues(BufferedInputStream istream) throws IOException {
        LDAPMatchingRuleSchema readObject = (LDAPMatchingRuleSchema)LDAPMatchingRuleSchema.readDSML(istream);
        this.oid = readObject.getID();
        this.names = readObject.getNames();
        this.description = readObject.getDescription();
        this.obsolete = readObject.isObsolete();
        Enumeration enumer = readObject.getQualifierNames();
        while (enumer.hasMoreElements()) {
            String xname = (String)enumer.nextElement();
            String[] qualifierVals = readObject.getQualifier(xname);
            this.setQualifier(xname, qualifierVals);
        }
        super.setValue(this.formatString());
        this.syntaxString = readObject.getSyntaxString();
        this.attributes = readObject.getAttributes();
        readObject = null;
    }

    protected void writeValue(Writer out) throws IOException {
        String value = this.formatString();
        out.write(ValueXMLhandler.newLine(2));
        out.write("<value>");
        out.write(value);
        out.write("</value>");
    }

    protected void writeValue(StringBuffer buff) {
        String value = this.formatString();
        buff.append(ValueXMLhandler.newLine(2));
        buff.append("<value>");
        buff.append(value);
        buff.append("</value>");
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPMatchingRuleSchema.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPMatchingRuleSchema)xmlreader.parseXML(input);
    }

    private static LDAPXMLHandler getTopXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPMatchingRuleSchema.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPMatchingRuleSchema)this.valuelist.get(0));
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("attr")) {
                    this.valuelist.add(value);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator valueiterator = this.valuelist.iterator();
                LDAPMatchingRuleSchema attr = new LDAPMatchingRuleSchema();
                byte[] temp = (byte[])valueiterator.next();
                StringBuffer bf = new StringBuffer(temp.length);
                for (int i = 0; i < temp.length; ++i) {
                    bf.append((char)temp[i]);
                }
                try {
                    SchemaParser matchParser = new SchemaParser(bf.toString());
                    attr.names = (String[])matchParser.getNames().clone();
                    attr.oid = matchParser.getID();
                    attr.description = matchParser.getDescription();
                    attr.obsolete = matchParser.getObsolete();
                    attr.syntaxString = matchParser.getSyntax();
                    attr.setValue(attr.formatString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e.toString());
                }
                this.setObject(attr);
                this.valuelist.clear();
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("value")) {
                    this.valuelist.add(value);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }
}

