/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.client.Debug;
import com.novell.ldap.client.RespControlVector;
import com.novell.ldap.rfc2251.RfcControl;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcRequest;
import com.novell.ldap.util.DSMLReader;
import com.novell.ldap.util.DSMLWriter;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class LDAPMessage
implements Externalizable {
    public static final int BIND_REQUEST = 0;
    public static final int BIND_RESPONSE = 1;
    public static final int UNBIND_REQUEST = 2;
    public static final int SEARCH_REQUEST = 3;
    public static final int SEARCH_RESPONSE = 4;
    public static final int SEARCH_RESULT = 5;
    public static final int MODIFY_REQUEST = 6;
    public static final int MODIFY_RESPONSE = 7;
    public static final int ADD_REQUEST = 8;
    public static final int ADD_RESPONSE = 9;
    public static final int DEL_REQUEST = 10;
    public static final int DEL_RESPONSE = 11;
    public static final int MODIFY_RDN_REQUEST = 12;
    public static final int MODIFY_RDN_RESPONSE = 13;
    public static final int COMPARE_REQUEST = 14;
    public static final int COMPARE_RESPONSE = 15;
    public static final int ABANDON_REQUEST = 16;
    public static final int SEARCH_RESULT_REFERENCE = 19;
    public static final int EXTENDED_REQUEST = 23;
    public static final int EXTENDED_RESPONSE = 24;
    public static final int INTERMEDIATE_RESPONSE = 25;
    protected RfcLDAPMessage message;
    private int imsgNum = -1;
    private int messageType = -1;
    private String stringTag = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;

    LDAPMessage() {
    }

    LDAPMessage(int messageType) {
        this.messageType = messageType;
    }

    LDAPMessage(int type, RfcRequest op, LDAPControl[] controls) {
        this.messageType = type;
        RfcControls asn1Ctrls = null;
        if (controls != null) {
            asn1Ctrls = new RfcControls();
            for (int i = 0; i < controls.length; ++i) {
                asn1Ctrls.add(controls[i].getASN1Object());
            }
        }
        this.message = new RfcLDAPMessage(op, asn1Ctrls);
        Debug.trace("APIRequests", "Creating " + this.toString());
    }

    protected LDAPMessage(RfcLDAPMessage message) {
        this.message = message;
    }

    final LDAPMessage clone(String dn, String filter, boolean reference) throws LDAPException {
        return new LDAPMessage((RfcLDAPMessage)this.message.dupMessage(dn, filter, reference));
    }

    final LDAPMessage getRequestingMessage() {
        if (this.isRequest()) {
            throw new RuntimeException("LDAPMessage: Cannot retrieve requesting message for an LDAP Request Message");
        }
        return this.message.getRequestingMessage();
    }

    public LDAPControl[] getControls() {
        LDAPControl[] controls = null;
        RfcControls asn1Ctrls = this.message.getControls();
        if (asn1Ctrls != null) {
            controls = new LDAPControl[asn1Ctrls.size()];
            for (int i = 0; i < asn1Ctrls.size(); ++i) {
                RfcControl rfcCtl = (RfcControl)asn1Ctrls.get(i);
                String oid = rfcCtl.getControlType().stringValue();
                byte[] value = rfcCtl.getControlValue().byteValue();
                boolean critical = rfcCtl.getCriticality().booleanValue();
                controls[i] = this.controlFactory(oid, critical, value);
            }
        }
        return controls;
    }

    private final LDAPControl controlFactory(String oid, boolean critical, byte[] value) {
        RespControlVector regControls = LDAPControl.getRegisteredControls();
        try {
            Class respCtlClass = regControls.findResponseControl(oid);
            if (respCtlClass == null) {
                return new LDAPControl(oid, critical, value);
            }
            Debug.trace("Controls", "For oid " + oid + ", found class " + respCtlClass.toString());
            Class[] argsClass = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LDAPMessage.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE, array$B == null ? (array$B = LDAPMessage.class$("[B")) : array$B};
            Object[] args = new Object[]{oid, new Boolean(critical), value};
            ReflectiveOperationException ex = null;
            try {
                Constructor ctlConstructor = respCtlClass.getConstructor(argsClass);
                try {
                    Object ctl = null;
                    ctl = ctlConstructor.newInstance(args);
                    return ctl;
                }
                catch (InstantiationException e) {
                    ex = e;
                }
                catch (IllegalAccessException e) {
                    ex = e;
                }
                catch (InvocationTargetException e) {
                    ex = e;
                }
            }
            catch (NoSuchMethodException e) {
                ex = e;
            }
            Debug.trace("Controls", "Unable to create new instance of child LDAPControl");
            Debug.trace("Controls", ex.toString());
        }
        catch (NoSuchFieldException e) {
            Debug.trace("Controls", "Oid " + oid + " not registered");
        }
        return new LDAPControl(oid, critical, value);
    }

    public int getMessageID() {
        if (this.imsgNum == -1) {
            this.imsgNum = this.message.getMessageID();
        }
        return this.imsgNum;
    }

    public int getType() {
        if (this.messageType == -1) {
            this.messageType = this.message.getType();
        }
        return this.messageType;
    }

    public boolean isRequest() {
        return this.message.isRequest();
    }

    RfcLDAPMessage getASN1Object() {
        return this.message;
    }

    public String toString() {
        return this.getName() + "(" + this.getMessageID() + "): " + this.message.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String getName() {
        void var1_1;
        switch (this.getType()) {
            case 4: {
                String name = "LDAPSearchResponse";
                break;
            }
            case 5: {
                String name = "LDAPSearchResult";
                break;
            }
            case 3: {
                String name = "LDAPSearchRequest";
                break;
            }
            case 6: {
                String name = "LDAPModifyRequest";
                break;
            }
            case 7: {
                String name = "LDAPModifyResponse";
                break;
            }
            case 8: {
                String name = "LDAPAddRequest";
                break;
            }
            case 9: {
                String name = "LDAPAddResponse";
                break;
            }
            case 10: {
                String name = "LDAPDelRequest";
                break;
            }
            case 11: {
                String name = "LDAPDelResponse";
                break;
            }
            case 12: {
                String name = "LDAPModifyRDNRequest";
                break;
            }
            case 13: {
                String name = "LDAPModifyRDNResponse";
                break;
            }
            case 14: {
                String name = "LDAPCompareRequest";
                break;
            }
            case 15: {
                String name = "LDAPCompareResponse";
                break;
            }
            case 0: {
                String name = "LDAPBindRequest";
                break;
            }
            case 1: {
                String name = "LDAPBindResponse";
                break;
            }
            case 2: {
                String name = "LDAPUnbindRequest";
                break;
            }
            case 16: {
                String name = "LDAPAbandonRequest";
                break;
            }
            case 19: {
                String name = "LDAPSearchResultReference";
                break;
            }
            case 23: {
                String name = "LDAPExtendedRequest";
                break;
            }
            case 24: {
                String name = "LDAPExtendedResponse";
                break;
            }
            case 25: {
                String name = "LDAPIntermediateResponse";
                break;
            }
            default: {
                throw new RuntimeException("LDAPMessage: Unknown Type " + this.getType());
            }
        }
        return var1_1;
    }

    public void setTag(String stringTag) {
        this.stringTag = stringTag;
    }

    public String getTag() {
        if (this.stringTag != null) {
            return this.stringTag;
        }
        if (this.isRequest()) {
            return null;
        }
        LDAPMessage m = this.getRequestingMessage();
        if (m == null) {
            return null;
        }
        return m.stringTag;
    }

    public void writeDSML(OutputStream oout) throws IOException {
        DSMLWriter out = new DSMLWriter(oout);
        try {
            out.useIndent(true);
            out.setIndent(4);
            out.writeMessage(this);
            out.finish();
        }
        catch (LDAPLocalException lDAPLocalException) {
            // empty catch block
        }
    }

    public static Object readDSML(InputStream input) throws IOException {
        LDAPMessage msg = null;
        try {
            DSMLReader reader = new DSMLReader(input);
            msg = reader.readMessage();
        }
        catch (LDAPLocalException e) {
            e.printStackTrace();
            throw new IOException("LDAPLocalException" + e);
        }
        return msg;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        String header = "\n\n";
        header = header + "*************************************************************************\n";
        header = header + "** The encrypted data above and below is the Class definition and  ******\n";
        header = header + "** other data specific to Java Serialization Protocol. The data  ********\n";
        header = header + "** which is of most application specific interest is as follows... ******\n";
        header = header + "*************************************************************************\n";
        header = header + "****************** Start of application data ****************************\n";
        header = header + "*************************************************************************\n\n";
        String tail = "";
        tail = tail + "\n*************************************************************************\n";
        tail = tail + "****************** End of application data ******************************\n";
        tail = tail + "*************************************************************************\n";
        try {
            DSMLWriter writer = new DSMLWriter((ObjectOutputStream)out);
            writer.useIndent(true);
            writer.setIndent(4);
            out.writeUTF(header);
            writer.writeMessage(this);
            writer.finish();
            out.writeUTF(tail);
        }
        catch (LDAPLocalException le) {
            le.printStackTrace();
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ObjectInputStream reader = (ObjectInputStream)in;
        StringBuffer rawBuff = new StringBuffer();
        while (reader.available() != 0) {
            rawBuff.append((char)reader.read());
        }
        String readData = rawBuff.toString();
        String readProperties = readData.substring(readData.indexOf(60), readData.lastIndexOf(62) + 1);
        StringBuffer parsedBuff = new StringBuffer();
        ValueXMLhandler.parseInput(readProperties, parsedBuff);
        BufferedInputStream istream = new BufferedInputStream(new ByteArrayInputStream(parsedBuff.toString().getBytes()));
        LDAPMessage readObject = null;
        try {
            DSMLReader dsmlreader = new DSMLReader(istream);
            readObject = dsmlreader.readMessage();
        }
        catch (LDAPLocalException e) {
            throw new IOException("LDAPLocalException" + e);
        }
        LDAPControl[] cont = readObject.getControls();
        RfcControls asn1Ctrls = null;
        Object operation = null;
        if (cont != null) {
            asn1Ctrls = new RfcControls();
            for (int i = 0; i < cont.length; ++i) {
                asn1Ctrls.add(cont[i].getASN1Object());
            }
        }
        this.setDeserializedValues(readObject, asn1Ctrls);
    }

    protected void setDeserializedValues(LDAPMessage readObject, RfcControls asn1Ctrls) throws IOException, ClassNotFoundException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

