/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.client;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class Debug {
    static SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final boolean LDAP_DEBUG = true;
    public static final String all = "TraceAll";
    public static final String rawInput = "RawInput";
    public static final String rawOutput = "RawOutput";
    public static final String referrals = "Referrals";
    public static final String messages = "Messages";
    public static final String apiRequests = "APIRequests";
    public static final String bindSemaphore = "BindSemaphore";
    public static final String controls = "Controls";
    public static final String asn1 = "ASN1";
    public static final String encoding = "Encoding";
    public static final String decoding = "Decoding";
    public static final String connections = "Connections";
    public static final String saslBind = "SaslBind";
    public static final String TLS = "TraceTLS";
    public static final String urlParse = "UrlParse";
    public static final String buffer = "DumpBuffer";
    public static final String objects = "DumpObject";
    public static final String objectHierarchy = "DumpObjectHierarchy";
    public static final String objectConstructors = "DumpObjectConstructors";
    public static final String objectFields = "DumpObjectFields";
    public static final String objectMethods = "DumpObjectMethods";
    public static final String traceInstructions = "VMTraceInstructions";
    public static final String traceMethodCalls = "VMTraceMethodCalls";
    public static final String EventsCalls = "EventsTrace";
    private static PrintStream debugOut = System.err;
    private static boolean dumpBuffer = false;
    private static boolean dumpObject = false;
    private static boolean dumpObjectHierarchy = false;
    private static boolean dumpObjectConstructors = false;
    private static boolean dumpObjectFields = false;
    private static boolean dumpObjectMethods = false;
    private static boolean VMtraceInstructions = false;
    private static boolean VMtraceMethodCalls = false;
    private static boolean traceControls = false;
    private static boolean traceRawInput = false;
    private static boolean traceRawOutput = false;
    private static boolean traceASN1 = false;
    private static boolean traceEncoding = false;
    private static boolean traceDecoding = false;
    private static boolean traceReferrals = false;
    private static boolean traceMessages = false;
    private static boolean traceBindSemaphore = false;
    private static boolean traceAPIRequests = false;
    private static boolean traceUrlParse = false;
    private static boolean traceConnections = false;
    private static boolean traceTLS = false;
    private static boolean traceSaslBind = false;
    private static boolean traceevents = false;
    private static Properties objprop = new Properties();
    private static Runtime run = Runtime.getRuntime();

    private Debug() {
    }

    private static final boolean toggle(boolean b) {
        b = !b;
        return b;
    }

    public static final boolean trace(String type) {
        if (type.equalsIgnoreCase(all)) {
            return traceRawInput || traceRawOutput || traceReferrals || traceMessages || traceBindSemaphore || traceAPIRequests || traceUrlParse || traceASN1 || traceEncoding || traceDecoding || traceControls || traceConnections || traceSaslBind || traceTLS;
        }
        if (type.equalsIgnoreCase(rawInput)) {
            return traceRawInput;
        }
        if (type.equalsIgnoreCase(rawOutput)) {
            return traceRawOutput;
        }
        if (type.equalsIgnoreCase(referrals)) {
            return traceReferrals;
        }
        if (type.equalsIgnoreCase(messages)) {
            return traceMessages;
        }
        if (type.equalsIgnoreCase(apiRequests)) {
            return traceAPIRequests;
        }
        if (type.equalsIgnoreCase(bindSemaphore)) {
            return traceBindSemaphore;
        }
        if (type.equalsIgnoreCase(urlParse)) {
            return traceUrlParse;
        }
        if (type.equalsIgnoreCase(asn1)) {
            return traceASN1;
        }
        if (type.equalsIgnoreCase(encoding)) {
            return traceEncoding;
        }
        if (type.equalsIgnoreCase(decoding)) {
            return traceDecoding;
        }
        if (type.equalsIgnoreCase(controls)) {
            return traceControls;
        }
        if (type.equalsIgnoreCase(connections)) {
            return traceConnections;
        }
        if (type.equalsIgnoreCase(saslBind)) {
            return traceSaslBind;
        }
        if (type.equalsIgnoreCase(TLS)) {
            return traceTLS;
        }
        if (type.equalsIgnoreCase(EventsCalls)) {
            return traceevents;
        }
        return false;
    }

    public static final void setTraceStream(PrintStream stream) {
        debugOut = stream;
    }

    public static final void setTrace(String type, boolean val) {
        if (type.equalsIgnoreCase(all)) {
            traceRawInput = val;
            traceRawOutput = val;
            traceReferrals = val;
            traceMessages = val;
            traceAPIRequests = val;
            traceBindSemaphore = val;
            traceUrlParse = val;
            traceASN1 = val;
            traceEncoding = val;
            traceDecoding = val;
            traceConnections = val;
            traceControls = val;
            traceSaslBind = val;
            traceTLS = val;
        } else if (type.equalsIgnoreCase(rawInput)) {
            traceRawInput = val;
        } else if (type.equalsIgnoreCase(controls)) {
            traceControls = val;
        } else if (type.equalsIgnoreCase(rawOutput)) {
            traceRawOutput = val;
        } else if (type.equalsIgnoreCase(referrals)) {
            traceReferrals = val;
        } else if (type.equalsIgnoreCase(messages)) {
            traceMessages = val;
        } else if (type.equalsIgnoreCase(apiRequests)) {
            traceAPIRequests = val;
        } else if (type.equalsIgnoreCase(bindSemaphore)) {
            traceBindSemaphore = val;
        } else if (type.equalsIgnoreCase(urlParse)) {
            traceUrlParse = val;
        } else if (type.equalsIgnoreCase(asn1)) {
            traceASN1 = val;
        } else if (type.equalsIgnoreCase(encoding)) {
            traceEncoding = val;
        } else if (type.equalsIgnoreCase(decoding)) {
            traceDecoding = val;
        } else if (type.equalsIgnoreCase(connections)) {
            traceConnections = val;
        } else if (type.equalsIgnoreCase(saslBind)) {
            traceSaslBind = val;
        } else if (type.equalsIgnoreCase(TLS)) {
            traceTLS = val;
        }
    }

    public static final void trace(String type, String str) {
        String tracing = "unknown";
        boolean printit = false;
        if (type.equalsIgnoreCase(all)) {
            printit = traceRawInput || traceRawOutput || traceReferrals || traceMessages || traceAPIRequests || traceBindSemaphore || traceUrlParse || traceEncoding || traceASN1 || traceDecoding || traceControls || traceConnections || traceSaslBind || traceTLS;
            tracing = "all";
        } else if (type.equalsIgnoreCase(rawInput)) {
            printit = traceRawInput;
            tracing = "traceRawInput";
        } else if (type.equalsIgnoreCase(rawOutput)) {
            printit = traceRawOutput;
            tracing = "traceRawOutput";
        } else if (type.equalsIgnoreCase(referrals)) {
            printit = traceReferrals;
            tracing = "traceReferrals";
        } else if (type.equalsIgnoreCase(controls)) {
            printit = traceControls;
            tracing = "traceControls";
        } else if (type.equalsIgnoreCase(messages)) {
            printit = traceMessages;
            tracing = "traceMessages";
        } else if (type.equalsIgnoreCase(apiRequests)) {
            printit = traceAPIRequests;
            tracing = "traceAPIRequests";
        } else if (type.equalsIgnoreCase(bindSemaphore)) {
            printit = traceBindSemaphore;
            tracing = "traceBindSemaphore";
        } else if (type.equalsIgnoreCase(urlParse)) {
            printit = traceUrlParse;
            tracing = "traceUrlParse";
        } else if (type.equalsIgnoreCase(asn1)) {
            printit = traceASN1;
            tracing = "traceASN1";
        } else if (type.equalsIgnoreCase(encoding)) {
            printit = traceEncoding;
            tracing = "traceEncoding";
        } else if (type.equalsIgnoreCase(decoding)) {
            printit = traceDecoding;
            tracing = "traceDecoding";
        } else if (type.equalsIgnoreCase(connections)) {
            printit = traceConnections;
            tracing = "traceConnections";
        } else if (type.equalsIgnoreCase(saslBind)) {
            printit = traceSaslBind;
            tracing = "traceSaslBind";
        } else if (type.equalsIgnoreCase(TLS)) {
            printit = traceTLS;
            tracing = "traceTLS";
        } else if (type.equalsIgnoreCase(EventsCalls)) {
            printit = traceevents;
            tracing = "traceEvents";
        }
        if (printit) {
            if (str == null) {
                debugOut.println("  \nprintDebug: Cannot print NULL string");
            } else {
                Date time = new Date();
                String dateString = formatter.format(time);
                debugOut.println(dateString + " " + tracing + ": " + str);
            }
        }
    }

    public static final boolean VMtraceInstructions() {
        return VMtraceInstructions;
    }

    public static final void VMtraceInstructions(boolean onOff) {
        if (VMtraceInstructions) {
            run.traceInstructions(onOff);
        }
    }

    public static final boolean VMtraceMethodCalls() {
        return VMtraceMethodCalls;
    }

    public static void VMtraceMethodCalls(boolean onOff) {
        if (VMtraceMethodCalls) {
            run.traceMethodCalls(onOff);
        }
    }

    public static final long totalMemory() {
        return run.totalMemory();
    }

    public static final long freeMemory() {
        return run.freeMemory();
    }

    public static final boolean dumpObject() {
        return dumpObject;
    }

    public static final void setDumpObject(boolean val) {
        dumpObject = val;
        dumpObject = true;
        dumpObjectHierarchy = true;
        dumpObjectConstructors = true;
        dumpObjectFields = true;
        dumpObjectMethods = true;
    }

    public static final boolean dumpObjectHierarchy() {
        return dumpObjectHierarchy;
    }

    public static final void setDumpObjectHierarchy(boolean val) {
        dumpObject = val;
        dumpObjectHierarchy = val;
    }

    public static final boolean dumpObjectConstructors() {
        return dumpObjectConstructors;
    }

    public static final void setDumpObjectConstructors(boolean val) {
        dumpObject = val;
        dumpObjectConstructors = val;
    }

    public static final boolean dumpObjectFields() {
        return dumpObjectFields;
    }

    public static final void setDumpObjectFields(boolean val) {
        dumpObject = val;
        dumpObjectFields = val;
    }

    public static final boolean dumpObjectMethods() {
        return dumpObjectMethods;
    }

    public static final void setDumpObjectMethods(boolean val) {
        dumpObject = val;
        dumpObjectMethods = val;
    }

    public static final void dumpObject(Object obj) {
        int level = 2;
        if (obj == null) {
            debugOut.println("  \ndumpObject: No class information obtainable for NULL class");
            return;
        }
        if (!dumpObject) {
            return;
        }
        Class<?> theClass = obj.getClass();
        if (theClass == null) {
            debugOut.println("\ndumpObject: No class information obtainable for " + obj.toString());
            return;
        }
        Class oldClass = (Class)objprop.put(theClass.getName(), theClass);
        if (oldClass != null) {
            return;
        }
        debugOut.println("\nV------------------------------------------------------------------------------V");
        debugOut.println("Object of class  " + theClass.getName());
        debugOut.println("\n  " + obj.toString() + "\n");
        if (dumpObjectHierarchy) {
            Class<?>[] Dclasses = theClass.getDeclaredClasses();
            debugOut.println("  Classes returned by getDeclaredClasses is " + Dclasses.length);
            for (int i = 1; i <= Dclasses.length; ++i) {
                debugOut.println("      " + i + " " + Dclasses[i - 1].getName());
            }
            Class<?> DCclass = theClass.getDeclaringClass();
            if (DCclass == null) {
                debugOut.println("  Class returned by getDeclaringClass is null");
            } else {
                debugOut.println("  Class returned by getDeclaringClass is " + DCclass.getName());
            }
            Object[] gsigners = theClass.getSigners();
            if (gsigners == null) {
                debugOut.println("  Signers returned by getSigners is null");
            } else {
                debugOut.println("  Signers returned by getSigners is " + gsigners.length);
                for (int i = 1; i <= gsigners.length; ++i) {
                    debugOut.println("      " + i + " " + gsigners[i - 1].toString());
                }
            }
            Class<?>[] classes = theClass.getClasses();
            debugOut.println("  Classes returned by getClasses is " + classes.length);
            for (int i = 1; i <= classes.length; ++i) {
                debugOut.println("      " + i + " " + classes[i - 1].getName());
            }
            Class<?> superClass = theClass;
            debugOut.println("\n  Class Hierarchy");
            Debug.dumpClasses(superClass, level);
        }
        if (dumpObjectConstructors) {
            Constructor<?>[] constructors = theClass.getConstructors();
            debugOut.println("  Constructors returned by getConstructors is " + constructors.length);
            for (int i = 1; i <= constructors.length; ++i) {
                debugOut.println("      " + i + " " + constructors[i - 1].getName() + ": " + constructors[i - 1].toString());
            }
            Constructor<?>[] dconstructors = theClass.getDeclaredConstructors();
            debugOut.println("  Declared Constructors returned by getDeclaredConstructors is " + dconstructors.length);
            for (int i = 1; i <= dconstructors.length; ++i) {
                debugOut.println("      " + i + " " + dconstructors[i - 1].getName() + ": " + dconstructors[i - 1].toString());
            }
        }
        if (dumpObjectFields) {
            Field[] gfields = theClass.getFields();
            debugOut.println("  Fields returned by getFields is " + gfields.length);
            for (int i = 1; i <= gfields.length; ++i) {
                debugOut.println("      " + i + " " + gfields[i - 1].getName() + ": " + gfields[i - 1].toString());
                Class<?> fieldClass = gfields[i - 1].getType();
                if (fieldClass.isPrimitive()) continue;
                Debug.dumpClasses(fieldClass, level + 2);
            }
            Field[] dfields = theClass.getDeclaredFields();
            debugOut.println("  Fields returned by getDeclaredFields is " + dfields.length);
            for (int i = 1; i <= dfields.length; ++i) {
                debugOut.println("      " + i + " " + dfields[i - 1].getName() + ": " + dfields[i - 1].toString());
                Class<?> fieldClass = dfields[i - 1].getType();
                if (fieldClass.isPrimitive()) continue;
                Debug.dumpClasses(fieldClass, level + 2);
            }
        }
        if (dumpObjectMethods) {
            try {
                Method[] gmethods = theClass.getMethods();
                debugOut.println("  Methods returned by getMethods is " + gmethods.length);
                for (int i = 1; i <= gmethods.length; ++i) {
                    debugOut.println("      " + i + " " + gmethods[i - 1].getName() + ": " + gmethods[i - 1].toString());
                }
            }
            catch (NoClassDefFoundError e) {
                debugOut.println("  getMethods returned NoClassDefFoundError Exception " + e.toString());
            }
            try {
                Method[] dmethods = theClass.getDeclaredMethods();
                debugOut.println("  Methods returned by getDeclaredMethods is " + dmethods.length);
                for (int i = 1; i <= dmethods.length; ++i) {
                    debugOut.println("      " + i + " " + dmethods[i - 1].getName() + ": " + dmethods[i - 1].toString());
                }
            }
            catch (NoClassDefFoundError e) {
                debugOut.println("  getDeclaredMethods returned NoClassDefFoundError Exception " + e.toString());
            }
        }
        debugOut.println("\n^------------------------------------------------------------------------------^");
    }

    private static final void dumpInterfaces(Class obj, int level) {
        Class<?>[] sinterfaces = obj.getInterfaces();
        for (int i = 1; i <= sinterfaces.length; ++i) {
            for (int j = 0; j < level; ++j) {
                debugOut.print("  ");
            }
            debugOut.println(sinterfaces[i - 1].toString());
            Debug.dumpInterfaces(sinterfaces[i - 1], level + 1);
        }
    }

    private static final void dumpClasses(Class obj, int level) {
        do {
            for (int j = 0; j < level; ++j) {
                debugOut.print("  ");
            }
            debugOut.println(obj.toString());
            Debug.dumpInterfaces(obj, level + 1);
        } while ((obj = obj.getSuperclass()) != null);
    }

    public static final boolean dumpBuffer() {
        return dumpBuffer;
    }

    public static final void setDumpBuffer(boolean val) {
        dumpBuffer = val;
    }

    public static final void dumpBuffer(String msg, byte[] inBuffer, int fileOffset, int length) {
        int byteCnt = 0;
        byte[] tstLine = new byte[16];
        boolean haveTstLine = false;
        boolean matchTstLine = false;
        boolean matchLastLine = false;
        if (!dumpBuffer) {
            return;
        }
        debugOut.println(msg);
        while (byteCnt < length) {
            if (byteCnt + 16 >= length - 1) {
                if (matchLastLine) {
                    debugOut.println("******");
                }
                matchTstLine = false;
            } else {
                int i;
                if (haveTstLine) {
                    matchTstLine = false;
                    for (i = 0; i < 16; ++i) {
                        if (tstLine[i] == inBuffer[byteCnt + i]) continue;
                        if (matchLastLine) {
                            debugOut.println("******");
                        }
                        haveTstLine = false;
                        matchLastLine = false;
                        matchTstLine = false;
                        break;
                    }
                    matchLastLine = true;
                    matchTstLine = true;
                }
                if (!haveTstLine) {
                    for (i = 0; i < 16; ++i) {
                        tstLine[i] = inBuffer[byteCnt + i];
                    }
                    haveTstLine = true;
                    matchTstLine = false;
                    matchLastLine = false;
                }
            }
            if (matchTstLine) {
                byteCnt += 16;
                continue;
            }
            Debug.dumpLine(inBuffer, byteCnt, length, fileOffset);
            byteCnt += 16;
        }
    }

    private static final void dumpLine(byte[] inBuffer, int offset, int length, int addrOffset) {
        int itemCnt;
        int DOT = 46;
        byte SP = 32;
        int byteCnt = offset;
        String address = Integer.toHexString(offset + addrOffset);
        while (address.length() < 6) {
            address = "0" + address;
        }
        debugOut.print(address + "    ");
        for (itemCnt = 0; itemCnt < 16; ++itemCnt) {
            String hexDigits = Integer.toHexString(inBuffer[byteCnt]);
            ++byteCnt;
            if (hexDigits.length() > 2) {
                hexDigits = hexDigits.substring(hexDigits.length() - 2, hexDigits.length());
            }
            if (hexDigits.length() == 2) {
                debugOut.print(hexDigits + " ");
            } else {
                debugOut.print("0" + hexDigits + " ");
            }
            if (itemCnt == 7) {
                debugOut.print(" ");
            }
            if (byteCnt != length) continue;
            ++itemCnt;
            break;
        }
        byte[] b = new byte[itemCnt + 2];
        b[0] = 0;
        b[1] = (byte)itemCnt;
        for (int i = 0; i < itemCnt; ++i) {
            b[i + 2] = inBuffer[offset + i] < SP ? DOT : inBuffer[offset + i];
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(b));
            debugOut.println(dataStream.readUTF());
        }
        catch (Exception e) {
            debugOut.println(e.toString());
            debugOut.println(e.getMessage());
            System.exit(1);
        }
    }

    static {
        Properties prop = System.getProperties();
        String sep = prop.getProperty("path.separator", ";");
        StringTokenizer st = new StringTokenizer(prop.getProperty("ldap.debug", ""), sep);
        while (st.hasMoreTokens()) {
            String tn = new String(st.nextToken());
            if (tn.equalsIgnoreCase(traceInstructions)) {
                VMtraceInstructions = true;
                Debug.VMtraceInstructions(true);
                continue;
            }
            if (tn.equalsIgnoreCase(traceMethodCalls)) {
                VMtraceMethodCalls = true;
                Debug.VMtraceMethodCalls(true);
                continue;
            }
            if (tn.equalsIgnoreCase(buffer)) {
                dumpBuffer = true;
                continue;
            }
            if (tn.equalsIgnoreCase(objects)) {
                dumpObject = true;
                dumpObjectHierarchy = true;
                dumpObjectConstructors = true;
                dumpObjectFields = true;
                dumpObjectMethods = true;
                continue;
            }
            if (tn.equalsIgnoreCase(objectHierarchy)) {
                dumpObject = true;
                dumpObjectHierarchy = true;
                continue;
            }
            if (tn.equalsIgnoreCase(objectConstructors)) {
                dumpObject = true;
                dumpObjectConstructors = true;
                continue;
            }
            if (tn.equalsIgnoreCase(objectFields)) {
                dumpObject = true;
                dumpObjectFields = true;
                continue;
            }
            if (tn.equalsIgnoreCase(objectMethods)) {
                dumpObject = true;
                dumpObjectMethods = true;
                continue;
            }
            if (tn.equalsIgnoreCase(all)) {
                traceControls = true;
                traceRawInput = true;
                traceRawOutput = true;
                traceReferrals = true;
                traceMessages = true;
                traceAPIRequests = true;
                traceBindSemaphore = true;
                traceUrlParse = true;
                traceASN1 = true;
                traceEncoding = true;
                traceDecoding = true;
                traceConnections = true;
                traceSaslBind = true;
                traceTLS = true;
                continue;
            }
            if (tn.equalsIgnoreCase(rawInput)) {
                traceRawInput = Debug.toggle(traceRawInput);
                continue;
            }
            if (tn.equalsIgnoreCase(controls)) {
                traceControls = Debug.toggle(traceControls);
                continue;
            }
            if (tn.equalsIgnoreCase(rawOutput)) {
                traceRawOutput = Debug.toggle(traceRawOutput);
                continue;
            }
            if (tn.equalsIgnoreCase(referrals)) {
                traceReferrals = Debug.toggle(traceReferrals);
                continue;
            }
            if (tn.equalsIgnoreCase(messages)) {
                traceMessages = Debug.toggle(traceMessages);
                continue;
            }
            if (tn.equalsIgnoreCase(apiRequests)) {
                traceMessages = Debug.toggle(traceAPIRequests);
                continue;
            }
            if (tn.equalsIgnoreCase(bindSemaphore)) {
                traceMessages = Debug.toggle(traceBindSemaphore);
                continue;
            }
            if (tn.equalsIgnoreCase(urlParse)) {
                traceUrlParse = Debug.toggle(traceUrlParse);
                continue;
            }
            if (tn.equalsIgnoreCase(asn1)) {
                traceEncoding = Debug.toggle(traceASN1);
                continue;
            }
            if (tn.equalsIgnoreCase(encoding)) {
                traceEncoding = Debug.toggle(traceEncoding);
                continue;
            }
            if (tn.equalsIgnoreCase(decoding)) {
                traceDecoding = Debug.toggle(traceDecoding);
                continue;
            }
            if (tn.equalsIgnoreCase(connections)) {
                traceConnections = Debug.toggle(traceConnections);
                continue;
            }
            if (tn.equalsIgnoreCase(TLS)) {
                traceTLS = Debug.toggle(traceTLS);
                continue;
            }
            if (!tn.equalsIgnoreCase(saslBind)) continue;
            traceSaslBind = Debug.toggle(traceSaslBind);
        }
    }
}

