/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.controls;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Choice;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBEREncoder;
import com.novell.ldap.controls.LDAPEffectivePrivilegesSelection;
import java.util.ArrayList;
import java.util.Iterator;

public class LDAPEffectivePrivilegesControl
extends LDAPControl {
    private static String requestOID = "2.16.840.1.113719.1.27.101.33";

    public LDAPEffectivePrivilegesControl(boolean critical, boolean includeAllLegalAttributes, ArrayList selectionList) {
        super(requestOID, critical, null);
        ASN1Choice asn1_effectiveCtlChoice = null;
        if (includeAllLegalAttributes) {
            asn1_effectiveCtlChoice = new ASN1Choice(new ASN1Boolean(includeAllLegalAttributes));
        } else if (!selectionList.isEmpty()) {
            ASN1Sequence asn1_selections = new ASN1Sequence();
            ASN1Choice selectionChoice = null;
            Iterator ISelectionList = selectionList.iterator();
            while (ISelectionList.hasNext()) {
                LDAPEffectivePrivilegesSelection selection = (LDAPEffectivePrivilegesSelection)ISelectionList.next();
                String tmp = selection.getSelectionAttr();
                if (tmp != null) {
                    selectionChoice = new ASN1Choice(new ASN1OctetString(tmp));
                } else {
                    tmp = selection.getSelectionClass();
                    if (tmp != null) {
                        selectionChoice = new ASN1Choice(new ASN1OctetString(tmp));
                    }
                }
                asn1_selections.add(selectionChoice);
            }
            asn1_effectiveCtlChoice = asn1_selections.size() != 0 ? new ASN1Choice(asn1_selections) : new ASN1Choice(new ASN1Boolean(false));
        } else {
            asn1_effectiveCtlChoice = new ASN1Choice(new ASN1Boolean(false));
        }
        this.setValue(asn1_effectiveCtlChoice.getEncoding(new LBEREncoder()));
    }
}

