/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.controls;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBEREncoder;
import com.novell.ldap.client.Debug;

public class LDAPPersistSearchControl
extends LDAPControl {
    private static int SEQUENCE_SIZE = 3;
    private static int CHANGETYPES_INDEX = 0;
    private static int CHANGESONLY_INDEX = 1;
    private static int RETURNCONTROLS_INDEX = 2;
    private static LBEREncoder s_encoder = new LBEREncoder();
    private int m_changeTypes;
    private boolean m_changesOnly;
    private boolean m_returnControls;
    private ASN1Sequence m_sequence;
    private static String requestOID = "2.16.840.1.113730.3.4.3";
    private static String responseOID = "2.16.840.1.113730.3.4.7";
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int MODIFY = 4;
    public static final int MODDN = 8;
    public static final int ANY = 15;

    public LDAPPersistSearchControl() {
        this(15, true, true, true);
    }

    public LDAPPersistSearchControl(int changeTypes, boolean changesOnly, boolean returnControls, boolean isCritical) {
        super(requestOID, isCritical, null);
        this.m_changeTypes = changeTypes;
        this.m_changesOnly = changesOnly;
        this.m_returnControls = returnControls;
        this.m_sequence = new ASN1Sequence(SEQUENCE_SIZE);
        this.m_sequence.add(new ASN1Integer(this.m_changeTypes));
        this.m_sequence.add(new ASN1Boolean(this.m_changesOnly));
        this.m_sequence.add(new ASN1Boolean(this.m_returnControls));
        this.setValue();
    }

    public int getChangeTypes() {
        return this.m_changeTypes;
    }

    public void setChangeTypes(int changeTypes) {
        this.m_changeTypes = changeTypes;
        this.m_sequence.set(CHANGETYPES_INDEX, new ASN1Integer(this.m_changeTypes));
        this.setValue();
    }

    public boolean getReturnControls() {
        return this.m_returnControls;
    }

    public void setReturnControls(boolean returnControls) {
        this.m_returnControls = returnControls;
        this.m_sequence.set(RETURNCONTROLS_INDEX, new ASN1Boolean(this.m_returnControls));
        this.setValue();
    }

    public boolean getChangesOnly() {
        return this.m_changesOnly;
    }

    public void setChangesOnly(boolean changesOnly) {
        this.m_changesOnly = changesOnly;
        this.m_sequence.set(CHANGESONLY_INDEX, new ASN1Boolean(this.m_changesOnly));
        this.setValue();
    }

    public String toString() {
        byte[] data = this.m_sequence.getEncoding(s_encoder);
        StringBuffer buf = new StringBuffer(data.length);
        for (int i = 0; i < data.length; ++i) {
            buf.append(Byte.toString(data[i]));
            if (i >= data.length - 1) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    private void setValue() {
        super.setValue(this.m_sequence.getEncoding(s_encoder));
    }

    static {
        try {
            LDAPControl.register(responseOID, Class.forName("com.novell.ldap.controls.LDAPEntryChangeControl"));
            Debug.trace("Controls", "Registered class for Entry Change control.");
        }
        catch (ClassNotFoundException e) {
            Debug.trace("Controls", "Could not register class for Entry Change control - class not found");
        }
    }
}

