/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ConnectionStateEventData
implements EventResponseData {
    private final String connectiondn;
    private final int oldFlags;
    private final int newFlags;
    private final String sourceModule;

    public ConnectionStateEventData(ASN1Object message) throws IOException {
        byte[] data = ((ASN1OctetString)message).byteValue();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        LBERDecoder decode = new LBERDecoder();
        int[] length = new int[1];
        this.connectiondn = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.oldFlags = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.newFlags = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.sourceModule = ((ASN1OctetString)decode.decode(in, length)).stringValue();
    }

    public String getConnectiondn() {
        return this.connectiondn;
    }

    public int getNewFlags() {
        return this.newFlags;
    }

    public int getOldFlags() {
        return this.oldFlags;
    }

    public String getSourceModule() {
        return this.sourceModule;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ConnectionStateEvent[connectiondn=" + this.getConnectiondn() + "]");
        buf.append("[oldFlags=" + this.getOldFlags() + "]");
        buf.append("[newFlags=" + this.getNewFlags() + "]");
        buf.append("[SourceModule=" + this.getSourceModule() + "]]");
        return buf.toString();
    }
}

