/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.resources;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourcesHandler {
    private static ResourceBundle defaultResultCodes = null;
    private static ResourceBundle defaultMessages = null;
    private static String pkg = "com.novell.ldap.resources.";
    private static Locale defaultLocale = Locale.getDefault();

    private ResourcesHandler() {
    }

    public static String getMessage(String messageOrKey, Object[] arguments) {
        return ResourcesHandler.getMessage(messageOrKey, arguments, null);
    }

    public static String getMessage(String messageOrKey, Object[] arguments, Locale locale) {
        String pattern;
        ResourceBundle messages = null;
        if (messageOrKey == null) {
            messageOrKey = "";
        }
        try {
            if (locale == null || defaultLocale.equals(locale)) {
                locale = defaultLocale;
                if (defaultMessages == null) {
                    defaultMessages = ResourceBundle.getBundle(pkg + "ExceptionMessages", defaultLocale);
                }
                messages = defaultMessages;
            } else {
                messages = ResourceBundle.getBundle(pkg + "ExceptionMessages", locale);
            }
            pattern = messages.getString(messageOrKey);
        }
        catch (MissingResourceException mre) {
            pattern = messageOrKey;
        }
        if (arguments != null) {
            MessageFormat mf = new MessageFormat(pattern);
            mf.setLocale(locale);
            mf.applyPattern(pattern);
            pattern = mf.format(arguments);
        }
        return pattern;
    }

    public static String getResultString(int code) {
        return ResourcesHandler.getResultString(code, null);
    }

    public static String getResultString(int code, Locale locale) {
        String result;
        try {
            ResourceBundle messages;
            if (locale == null || defaultLocale.equals(locale)) {
                locale = defaultLocale;
                if (defaultResultCodes == null) {
                    defaultResultCodes = ResourceBundle.getBundle(pkg + "ResultCodeMessages", defaultLocale);
                }
                messages = defaultResultCodes;
            } else {
                messages = ResourceBundle.getBundle(pkg + "ResultCodeMessages", locale);
            }
            result = messages.getString(Integer.toString(code));
        }
        catch (MissingResourceException mre) {
            result = ResourcesHandler.getMessage("UNKNOWN_RESULT", new Object[]{new Integer(code)}, locale);
        }
        return result;
    }
}

