/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.rfc2251;

import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPOID;
import com.novell.ldap.rfc2251.RfcLDAPString;
import com.novell.ldap.rfc2251.RfcReferral;
import com.novell.ldap.rfc2251.RfcResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RfcExtendedResponse
extends ASN1Sequence
implements RfcResponse {
    public static final int RESPONSE_NAME = 10;
    public static final int RESPONSE = 11;
    private int referralIndex;
    private int responseNameIndex;
    private int responseIndex;

    public RfcExtendedResponse(ASN1Enumerated resultCode, RfcLDAPDN matchedDN, RfcLDAPString errorMessage, RfcReferral referral, RfcLDAPOID responseName, ASN1OctetString response) {
        super(6);
        this.add(resultCode);
        this.add(matchedDN);
        this.add(errorMessage);
        int counter = 3;
        if (referral != null) {
            this.add(referral);
            this.referralIndex = counter++;
        }
        if (responseName != null) {
            this.responseNameIndex = counter++;
            this.add(responseName);
        }
        if (response != null) {
            this.add(response);
            this.responseIndex = counter++;
        }
    }

    public RfcExtendedResponse(ASN1Decoder dec, InputStream in, int len) throws IOException {
        super(dec, in, len);
        if (this.size() > 3) {
            block5: for (int i = 3; i < this.size(); ++i) {
                ASN1Tagged obj = (ASN1Tagged)this.get(i);
                ASN1Identifier id = obj.getIdentifier();
                switch (id.getTag()) {
                    case 3: {
                        byte[] content = ((ASN1OctetString)obj.taggedValue()).byteValue();
                        ByteArrayInputStream bais = new ByteArrayInputStream(content);
                        this.set(i, new RfcReferral(dec, bais, content.length));
                        this.referralIndex = i;
                        continue block5;
                    }
                    case 10: {
                        this.set(i, new RfcLDAPOID(((ASN1OctetString)obj.taggedValue()).byteValue()));
                        this.responseNameIndex = i;
                        continue block5;
                    }
                    case 11: {
                        this.set(i, obj.taggedValue());
                        this.responseIndex = i;
                    }
                }
            }
        }
    }

    public final ASN1Enumerated getResultCode() {
        return (ASN1Enumerated)this.get(0);
    }

    public final RfcLDAPDN getMatchedDN() {
        return new RfcLDAPDN(((ASN1OctetString)this.get(1)).byteValue());
    }

    public final RfcLDAPString getErrorMessage() {
        return new RfcLDAPString(((ASN1OctetString)this.get(2)).byteValue());
    }

    public final RfcReferral getReferral() {
        return this.referralIndex != 0 ? (RfcReferral)this.get(this.referralIndex) : null;
    }

    public final RfcLDAPOID getResponseName() {
        return this.responseNameIndex != 0 ? (RfcLDAPOID)this.get(this.responseNameIndex) : null;
    }

    public final ASN1OctetString getResponse() {
        return this.responseIndex != 0 ? (ASN1OctetString)this.get(this.responseIndex) : null;
    }

    public final ASN1Identifier getIdentifier() {
        return new ASN1Identifier(1, true, 24);
    }
}

