/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import com.novell.sasl.client.DigestMD5SaslClient;
import com.novell.sasl.client.ExternalSaslClient;
import com.novell.sasl.client.NMASSaslClient;
import com.novell.security.sasl.SaslClient;
import com.novell.security.sasl.SaslClientFactory;
import com.novell.security.sasl.SaslException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;

public class ClientFactory
implements SaslClientFactory {
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map props, CallbackHandler cbh) throws SaslException {
        SaslClient client = null;
        if (props == null) {
            props = new HashMap<String, String>();
        }
        if (props.get("com.novell.security.sasl.qop") == null) {
            props.put("com.novell.security.sasl.qop", "auth");
        }
        if (props.get("com.novell.security.sasl.strength") == null) {
            props.put("com.novell.security.sasl.strength", "high,medium,low");
        }
        if (props.get("com.novell.security.sasl.server.authentication") == null) {
            props.put("com.novell.security.sasl.server.authentication", "false");
        }
        client = null;
        for (int i = 0; i < mechanisms.length && client == null; ++i) {
            if ("DIGEST-MD5".equals(mechanisms[i])) {
                client = DigestMD5SaslClient.getClient(authorizationId, protocol, serverName, props, cbh);
                continue;
            }
            if ("EXTERNAL".equals(mechanisms[i])) {
                client = ExternalSaslClient.getClient(authorizationId, protocol, serverName, props, cbh);
                continue;
            }
            if (!"NMAS_LOGIN".equals(mechanisms[i])) continue;
            client = NMASSaslClient.getClient(authorizationId, protocol, serverName, props, cbh);
        }
        return client;
    }

    public String[] getMechanismNames(Map props) {
        String[] mechanisms = new String[]{"DIGEST-MD5", "EXTERNAL", "NMAS_LOGIN"};
        return mechanisms;
    }
}

