/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.junit;

import com.novocode.junit.AbstractEvent;
import com.novocode.junit.Ansi;
import com.novocode.junit.OutputCapture;
import com.novocode.junit.RichLogger;
import com.novocode.junit.RunSettings;
import java.io.IOException;
import java.util.HashSet;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.scalatools.testing.Event;
import org.scalatools.testing.EventHandler;

final class EventDispatcher
extends RunListener {
    private final RichLogger logger;
    private final HashSet<String> reported = new HashSet();
    private final EventHandler handler;
    private final RunSettings settings;
    private OutputCapture capture;

    EventDispatcher(RichLogger richLogger, EventHandler eventHandler, RunSettings runSettings) {
        this.logger = richLogger;
        this.handler = eventHandler;
        this.settings = runSettings;
    }

    public void testAssumptionFailure(final Failure failure) {
        this.uncapture(true);
        this.postIfFirst(new AbstractEvent(this.settings.buildErrorName(failure.getDescription()), failure.getMessage(), org.scalatools.testing.Result.Skipped, failure.getException()){

            void logTo(RichLogger richLogger) {
                richLogger.warn("Test assumption in test " + this.ansiName + " failed: " + failure.getMessage());
            }
        });
    }

    public void testFailure(final Failure failure) {
        this.uncapture(true);
        this.postIfFirst(new AbstractEvent(this.settings.buildErrorName(failure.getDescription()), failure.getMessage(), org.scalatools.testing.Result.Failure, failure.getException()){

            void logTo(RichLogger richLogger) {
                richLogger.error("Test " + this.ansiName + " failed: " + failure.getMessage(), this.error);
            }
        });
    }

    public void testFinished(Description description) {
        this.uncapture(false);
        this.postIfFirst(new AbstractEvent(this.settings.buildInfoName(description), null, org.scalatools.testing.Result.Success, null){

            void logTo(RichLogger richLogger) {
                richLogger.debug("Test " + this.ansiName + " finished");
            }
        });
        this.logger.popCurrentTestClassName();
    }

    public void testIgnored(Description description) {
        this.postIfFirst(new AbstractEvent(this.settings.buildInfoName(description), null, org.scalatools.testing.Result.Skipped, null){

            void logTo(RichLogger richLogger) {
                richLogger.info("Test " + this.ansiName + " ignored");
            }
        });
    }

    public void testStarted(Description description) {
        this.logger.pushCurrentTestClassName(description.getClassName());
        this.debugOrInfo("Test " + this.settings.buildInfoName(description) + " started");
        this.capture();
    }

    public void testRunFinished(Result result) {
        this.debugOrInfo(Ansi.c("Test run finished: ", "\u001b[34m") + Ansi.c(result.getFailureCount() + " failed", result.getFailureCount() > 0 ? "\u001b[31m" : "\u001b[34m") + Ansi.c(", ", "\u001b[34m") + Ansi.c(result.getIgnoreCount() + " ignored", result.getIgnoreCount() > 0 ? "\u001b[33m" : "\u001b[34m") + Ansi.c(", " + result.getRunCount() + " total, " + (double)result.getRunTime() / 1000.0 + "s", "\u001b[34m"));
    }

    public void testRunStarted(Description description) {
        this.debugOrInfo(Ansi.c("Test run started", "\u001b[34m"));
    }

    void testExecutionFailed(String string, Throwable throwable) {
        this.post(new AbstractEvent(Ansi.c(string, "\u001b[31m"), "Test execution failed", org.scalatools.testing.Result.Error, throwable){

            void logTo(RichLogger richLogger) {
                richLogger.error("Execution of test " + this.ansiName + " failed", this.error);
            }
        });
    }

    private void postIfFirst(AbstractEvent abstractEvent) {
        abstractEvent.logTo(this.logger);
        if (this.reported.add(abstractEvent.testName())) {
            this.handler.handle((Event)abstractEvent);
        }
    }

    void post(AbstractEvent abstractEvent) {
        abstractEvent.logTo(this.logger);
        this.handler.handle((Event)abstractEvent);
    }

    private void capture() {
        if (this.settings.quiet && this.capture == null) {
            this.capture = OutputCapture.start();
        }
    }

    void uncapture(boolean bl) {
        if (this.settings.quiet && this.capture != null) {
            this.capture.stop();
            if (bl) {
                try {
                    this.capture.replay();
                }
                catch (IOException iOException) {
                    this.logger.error("Error replaying captured stdio", iOException);
                }
            }
            this.capture = null;
        }
    }

    private void debugOrInfo(String string) {
        if (this.settings.verbose) {
            this.logger.info(string);
        } else {
            this.logger.debug(string);
        }
    }
}

