/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.junit;

import com.novocode.junit.Ansi;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.junit.runner.Description;

class RunSettings {
    final boolean color;
    final boolean quiet;
    final boolean verbose;
    final boolean logAssert;
    private final boolean decodeScalaNames;
    private final HashSet<String> ignoreRunners = new HashSet();

    RunSettings(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string) {
        this.color = bl;
        this.decodeScalaNames = bl2;
        this.quiet = bl3;
        this.verbose = bl4;
        this.logAssert = bl5;
        for (String string2 : string.split(",")) {
            this.ignoreRunners.add(string2.trim());
        }
    }

    String decodeName(String string) {
        return this.decodeScalaNames ? RunSettings.decodeScalaName(string) : string;
    }

    private static String decodeScalaName(String string) {
        try {
            Class<?> clazz = Class.forName("scala.reflect.NameTransformer");
            Method method = clazz.getMethod("decode", String.class);
            String string2 = (String)method.invoke(null, string);
            return string2 == null ? string : string2;
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    String buildInfoName(Description description) {
        return this.buildColoredName(description, "\u001b[33m", "\u001b[36m", "\u001b[33m");
    }

    String buildErrorName(Description description) {
        return this.buildColoredName(description, "\u001b[33m", "\u001b[31m", "\u001b[33m");
    }

    String buildPlainName(Description description) {
        return this.buildColoredName(description, null, null, null);
    }

    private String buildColoredName(Description description, String string, String string2, String string3) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = this.decodeName(description.getClassName());
        int n2 = string4.indexOf(36);
        int n3 = n = n2 == -1 ? string4.lastIndexOf(46) : string4.lastIndexOf(46, n2);
        if (n == -1) {
            stringBuilder.append(Ansi.c(string4, string));
        } else {
            stringBuilder.append(string4.substring(0, n));
            stringBuilder.append('.');
            stringBuilder.append(Ansi.c(string4.substring(n + 1), string));
        }
        String string5 = description.getMethodName();
        if (string5 != null) {
            stringBuilder.append('.');
            int n4 = string5.lastIndexOf(91);
            int n5 = string5.lastIndexOf(93);
            if (n4 == -1 || n5 < n4) {
                stringBuilder.append(Ansi.c(this.decodeName(string5), string2));
            } else {
                stringBuilder.append(Ansi.c(this.decodeName(string5.substring(0, n4)), string2));
                stringBuilder.append('[');
                stringBuilder.append(Ansi.c(string5.substring(n4 + 1, n5), string3));
                stringBuilder.append(']');
            }
        }
        return stringBuilder.toString();
    }

    boolean ignoreRunner(String string) {
        return this.ignoreRunners.contains(string);
    }
}

