/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.junit;

import com.novocode.junit.Ansi;
import com.novocode.junit.RunSettings;
import java.util.Stack;
import org.scalatools.testing.Logger;

final class RichLogger {
    private final Logger[] loggers;
    private final RunSettings settings;
    private final Stack<String> currentTestClassName = new Stack();

    RichLogger(Logger[] loggerArray, RunSettings runSettings, String string) {
        this.loggers = loggerArray;
        this.settings = runSettings;
        this.currentTestClassName.push(string);
    }

    void pushCurrentTestClassName(String string) {
        this.currentTestClassName.push(string);
    }

    void popCurrentTestClassName() {
        if (this.currentTestClassName.size() > 1) {
            this.currentTestClassName.pop();
        }
    }

    void debug(String string) {
        for (Logger logger : this.loggers) {
            if (this.settings.color && logger.ansiCodesSupported()) {
                logger.debug(string);
                continue;
            }
            logger.debug(Ansi.filterAnsi(string));
        }
    }

    void error(String string) {
        for (Logger logger : this.loggers) {
            if (this.settings.color && logger.ansiCodesSupported()) {
                logger.error(string);
                continue;
            }
            logger.error(Ansi.filterAnsi(string));
        }
    }

    void error(String string, Throwable throwable) {
        this.error(string);
        if (throwable != null && (this.settings.logAssert || !(throwable instanceof AssertionError))) {
            this.logStackTrace(throwable);
        }
    }

    void info(String string) {
        for (Logger logger : this.loggers) {
            if (this.settings.color && logger.ansiCodesSupported()) {
                logger.info(string);
                continue;
            }
            logger.info(Ansi.filterAnsi(string));
        }
    }

    void warn(String string) {
        for (Logger logger : this.loggers) {
            if (this.settings.color && logger.ansiCodesSupported()) {
                logger.warn(string);
                continue;
            }
            logger.warn(Ansi.filterAnsi(string));
        }
    }

    private void logStackTrace(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string = this.currentTestClassName.peek();
        String string2 = this.settings.color ? this.findTestFileName(stackTraceElementArray, string) : null;
        this.logStackTracePart(stackTraceElementArray, stackTraceElementArray.length - 1, 0, throwable, string, string2);
    }

    private void logStackTracePart(StackTraceElement[] stackTraceElementArray, int n, int n2, Throwable throwable, String string, String string2) {
        int n3;
        int n4;
        int n5 = n;
        for (n4 = n3 = 0; n4 <= n; ++n4) {
            String string3;
            if (!stackTraceElementArray[n4].toString().startsWith("org.junit.")) continue;
            if (n4 == n3) {
                ++n3;
                continue;
            }
            for (n = n4 - 1; n > n3 && ((string3 = stackTraceElementArray[n].toString()).startsWith("java.lang.reflect.") || string3.startsWith("sun.reflect.")); --n) {
            }
            break;
        }
        for (n4 = n3; n4 <= n; ++n4) {
            this.error("    at " + this.stackTraceElementToString(stackTraceElementArray[n4], string, string2));
        }
        if (n5 != n) {
            this.error("    ...");
        } else if (n2 != 0) {
            this.error("    ... " + n2 + " more");
        }
        this.logStackTraceAsCause(stackTraceElementArray, throwable.getCause(), string, string2);
    }

    private void logStackTraceAsCause(StackTraceElement[] stackTraceElementArray, Throwable throwable, String string, String string2) {
        if (throwable == null) {
            return;
        }
        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        this.error("Caused by: " + throwable);
        this.logStackTracePart(stackTraceElementArray2, n, stackTraceElementArray2.length - 1 - n, throwable, string, string2);
    }

    private String findTestFileName(StackTraceElement[] stackTraceElementArray, String string) {
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string2 = stackTraceElement.getClassName();
            if (!string.equals(string2)) continue;
            return stackTraceElement.getFileName();
        }
        return null;
    }

    private String stackTraceElementToString(StackTraceElement stackTraceElement, String string, String string2) {
        boolean bl = this.settings.color && (string.equals(stackTraceElement.getClassName()) || string2 != null && string2.equals(stackTraceElement.getFileName()));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.settings.decodeName(stackTraceElement.getClassName() + '.' + stackTraceElement.getMethodName()));
        stringBuilder.append('(');
        if (stackTraceElement.isNativeMethod()) {
            stringBuilder.append(Ansi.c("Native Method", bl ? "\u001b[33m" : null));
        } else if (stackTraceElement.getFileName() == null) {
            stringBuilder.append(Ansi.c("Unknown Source", bl ? "\u001b[33m" : null));
        } else {
            stringBuilder.append(Ansi.c(stackTraceElement.getFileName(), bl ? "\u001b[35m" : null));
            if (stackTraceElement.getLineNumber() >= 0) {
                stringBuilder.append(':').append(Ansi.c(String.valueOf(stackTraceElement.getLineNumber()), bl ? "\u001b[33m" : null));
            }
        }
        return stringBuilder.append(')').toString();
    }
}

