/*
 * Decompiled with CFR 0.152.
 */
package com.onfido;

import com.onfido.api.ApiJson;
import com.onfido.api.Config;
import com.onfido.api.ResourceManager;
import com.onfido.exceptions.OnfidoException;
import com.onfido.models.Applicant;
import java.util.List;
import okhttp3.OkHttpClient;

public class ApplicantManager
extends ResourceManager {
    private ApiJson<Applicant> applicantParser = new ApiJson<Applicant>(Applicant.class);
    private ApiJson<Applicant.Request> requestFormatter = new ApiJson<Applicant.Request>(Applicant.Request.class);

    protected ApplicantManager(Config config, OkHttpClient client) {
        super("applicants/", config, client);
    }

    public Applicant create(Applicant.Request request) throws OnfidoException {
        return this.applicantParser.parse(this.post("", this.requestFormatter.toJson(request)));
    }

    public Applicant find(String applicantId) throws OnfidoException {
        return this.applicantParser.parse(this.get(applicantId));
    }

    public Applicant update(String applicantId, Applicant.Request request) throws OnfidoException {
        return this.applicantParser.parse(this.put(applicantId, this.requestFormatter.toJson(request)));
    }

    public void delete(String applicantId) throws OnfidoException {
        this.deleteRequest(applicantId);
    }

    public void restore(String applicantId) throws OnfidoException {
        this.post(applicantId + "/restore", "");
    }

    public List<Applicant> list(int page, int perPage, boolean includedDeleted) throws OnfidoException {
        return this.applicantParser.parseWrappedList(this.get("?page=" + page + "&per_page=" + perPage + "&include_deleted=" + includedDeleted), "applicants");
    }
}

