/*
 * Decompiled with CFR 0.152.
 */
package com.onfido;

import com.onfido.api.ApiJson;
import com.onfido.api.Config;
import com.onfido.api.FileDownload;
import com.onfido.api.ResourceManager;
import com.onfido.exceptions.OnfidoException;
import com.onfido.models.Check;
import java.util.List;
import okhttp3.OkHttpClient;

public class CheckManager
extends ResourceManager {
    private ApiJson<Check> checkParser = new ApiJson<Check>(Check.class);
    private ApiJson<Check.Request> requestFormatter = new ApiJson<Check.Request>(Check.Request.class);

    protected CheckManager(Config config, OkHttpClient client) {
        super("checks/", config, client);
    }

    public Check create(Check.Request request) throws OnfidoException {
        return this.checkParser.parse(this.post("", this.requestFormatter.toJson(request)));
    }

    public Check find(String checkId) throws OnfidoException {
        return this.checkParser.parse(this.get(checkId));
    }

    public List<Check> list(String applicantId) throws OnfidoException {
        return this.checkParser.parseWrappedList(this.get("?applicant_id=" + applicantId), "checks");
    }

    public void resume(String checkId) throws OnfidoException {
        this.post(checkId + "/resume", "");
    }

    public FileDownload download(String checkId) throws OnfidoException {
        return this.downloadRequest(checkId + "/download");
    }
}

