/*
 * Decompiled with CFR 0.152.
 */
package com.onfido;

import com.onfido.api.ApiJson;
import com.onfido.api.Config;
import com.onfido.api.FileDownload;
import com.onfido.api.ResourceManager;
import com.onfido.exceptions.OnfidoException;
import com.onfido.models.Document;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;

public class DocumentManager
extends ResourceManager {
    private ApiJson<Document> documentParser = new ApiJson<Document>(Document.class);

    protected DocumentManager(Config config, OkHttpClient client) {
        super("documents/", config, client);
    }

    public Document upload(InputStream inputStream, String fileName, Document.Request request) throws IOException, OnfidoException {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        this.addFormDataParam(builder, "applicant_id", request.getApplicantId());
        this.addFormDataParam(builder, "type", request.getType());
        this.addFormDataParam(builder, "side", request.getSide());
        this.addFormDataParam(builder, "issuing_country", request.getIssuingCountry());
        this.addFormDataParam(builder, "validate_image_quality", request.getValidateImageQuality());
        this.addFormDataParam(builder, "location", request.getLocation());
        builder.addFormDataPart("file", fileName, RequestBody.create((byte[])this.readInputStream(inputStream), (MediaType)MediaType.get((String)URLConnection.guessContentTypeFromName(fileName))));
        return this.documentParser.parse(this.uploadRequest("", (RequestBody)builder.build()));
    }

    public FileDownload download(String documentId) throws OnfidoException {
        return this.downloadRequest(documentId + "/download");
    }

    public Document find(String documentId) throws OnfidoException {
        return this.documentParser.parse(this.get(documentId));
    }

    public List<Document> list(String applicantId) throws OnfidoException {
        return this.documentParser.parseWrappedList(this.get("?applicant_id=" + applicantId), "documents");
    }
}

