/*
 * Decompiled with CFR 0.152.
 */
package com.onfido;

import com.onfido.api.ApiJson;
import com.onfido.api.Config;
import com.onfido.api.FileDownload;
import com.onfido.api.ResourceManager;
import com.onfido.exceptions.OnfidoException;
import com.onfido.models.LivePhoto;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;

public class LivePhotoManager
extends ResourceManager {
    private ApiJson<LivePhoto> livePhotoParser = new ApiJson<LivePhoto>(LivePhoto.class);

    protected LivePhotoManager(Config config, OkHttpClient client) {
        super("live_photos/", config, client);
    }

    public LivePhoto upload(InputStream inputStream, String fileName, LivePhoto.Request request) throws IOException, OnfidoException {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        this.addFormDataParam(builder, "applicant_id", request.getApplicantId());
        this.addFormDataParam(builder, "advanced_validation", request.getAdvancedValidation());
        builder.addFormDataPart("file", fileName, RequestBody.create((byte[])this.readInputStream(inputStream), (MediaType)MediaType.get((String)URLConnection.guessContentTypeFromName(fileName))));
        return this.livePhotoParser.parse(this.uploadRequest("", (RequestBody)builder.build()));
    }

    public FileDownload download(String livePhotoId) throws OnfidoException {
        return this.downloadRequest(livePhotoId + "/download");
    }

    public LivePhoto find(String livePhotoId) throws OnfidoException {
        return this.livePhotoParser.parse(this.get(livePhotoId));
    }

    public List<LivePhoto> list(String applicantId) throws OnfidoException {
        return this.livePhotoParser.parseWrappedList(this.get("?applicant_id=" + applicantId), "live_photos");
    }
}

