/*
 * Decompiled with CFR 0.152.
 */
package com.onfido;

import com.onfido.api.ApiJson;
import com.onfido.api.Config;
import com.onfido.api.FileDownload;
import com.onfido.api.ResourceManager;
import com.onfido.exceptions.OnfidoException;
import com.onfido.models.LiveVideo;
import java.util.List;
import okhttp3.OkHttpClient;

public class LiveVideoManager
extends ResourceManager {
    private ApiJson<LiveVideo> liveVideoParser = new ApiJson<LiveVideo>(LiveVideo.class);

    protected LiveVideoManager(Config config, OkHttpClient client) {
        super("live_videos/", config, client);
    }

    public FileDownload download(String liveVideoId) throws OnfidoException {
        return this.downloadRequest(liveVideoId + "/download");
    }

    public FileDownload downloadFrame(String liveVideoId) throws OnfidoException {
        return this.downloadRequest(liveVideoId + "/frame");
    }

    public LiveVideo find(String liveVideoId) throws OnfidoException {
        return this.liveVideoParser.parse(this.get(liveVideoId));
    }

    public List<LiveVideo> list(String applicantId) throws OnfidoException {
        return this.liveVideoParser.parseWrappedList(this.get("?applicant_id=" + applicantId), "live_videos");
    }
}

