/*
 * Decompiled with CFR 0.152.
 */
package com.onfido;

import com.onfido.api.ApiJson;
import com.onfido.api.Config;
import com.onfido.api.FileDownload;
import com.onfido.api.ResourceManager;
import com.onfido.exceptions.OnfidoException;
import com.onfido.models.MotionCapture;
import java.util.List;
import okhttp3.OkHttpClient;

public class MotionCaptureManager
extends ResourceManager {
    private final ApiJson<MotionCapture> motionCaptureParser = new ApiJson<MotionCapture>(MotionCapture.class);

    protected MotionCaptureManager(Config config, OkHttpClient client) {
        super("motion_captures/", config, client);
    }

    public FileDownload download(String motionCaptureId) throws OnfidoException {
        return this.downloadRequest(motionCaptureId + "/download");
    }

    public FileDownload downloadFrame(String motionCaptureId) throws OnfidoException {
        return this.downloadRequest(motionCaptureId + "/frame");
    }

    public MotionCapture find(String motionCaptureId) throws OnfidoException {
        return this.motionCaptureParser.parse(this.get(motionCaptureId));
    }

    public List<MotionCapture> list(String applicantId) throws OnfidoException {
        return this.motionCaptureParser.parseWrappedList(this.get("?applicant_id=" + applicantId), "motion_captures");
    }
}

