/*
 * Decompiled with CFR 0.152.
 */
package com.onfido;

import com.onfido.api.ApiJson;
import com.onfido.api.Config;
import com.onfido.api.ResourceManager;
import com.onfido.exceptions.OnfidoException;
import com.onfido.models.Task;
import com.onfido.models.TaskBase;
import com.onfido.models.TaskData;
import java.util.List;
import okhttp3.OkHttpClient;

public class TaskManager
extends ResourceManager {
    private ApiJson<TaskBase> taskBaseParser = new ApiJson<TaskBase>(TaskBase.class);
    private ApiJson<Task> taskParser = new ApiJson<Task>(Task.class);
    private ApiJson<TaskData.Request> requestFormatter = new ApiJson<TaskData.Request>(TaskData.Request.class);

    protected TaskManager(Config config, OkHttpClient client) {
        super("workflow_runs/", config, client);
    }

    public List<TaskBase> list(String workflowRunId) throws OnfidoException {
        return this.taskBaseParser.parseList(this.get(workflowRunId + "/tasks"));
    }

    public Task find(String workflowRunId, String taskId) throws OnfidoException {
        return this.taskParser.parse(this.get(workflowRunId + "/tasks/" + taskId));
    }

    public void complete(String workflowRunId, String taskId, TaskData.Request request) throws OnfidoException {
        this.post(workflowRunId + "/tasks/" + taskId + "/complete", this.requestFormatter.toJson(request));
    }
}

