/*
 * Decompiled with CFR 0.152.
 */
package com.onfido;

import com.onfido.api.ApiJson;
import com.onfido.api.Config;
import com.onfido.api.FileDownload;
import com.onfido.api.ResourceManager;
import com.onfido.exceptions.OnfidoException;
import com.onfido.models.WorkflowRun;
import okhttp3.OkHttpClient;

public class WorkflowRunManager
extends ResourceManager {
    private ApiJson<WorkflowRun> workflowRunParser = new ApiJson<WorkflowRun>(WorkflowRun.class);
    private ApiJson<WorkflowRun.Request> requestFormatter = new ApiJson<WorkflowRun.Request>(WorkflowRun.Request.class);

    protected WorkflowRunManager(Config config, OkHttpClient client) {
        super("workflow_runs/", config, client);
    }

    public WorkflowRun create(WorkflowRun.Request request) throws OnfidoException {
        return this.workflowRunParser.parse(this.post("", this.requestFormatter.toJson(request)));
    }

    public WorkflowRun find(String workflowRunId) throws OnfidoException {
        return this.workflowRunParser.parse(this.get(workflowRunId));
    }

    public FileDownload evidence(String workflowRunId) throws OnfidoException {
        return this.downloadRequest(workflowRunId + "/signed_evidence_file");
    }
}

