/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.api;

import com.onfido.exceptions.OnfidoException;
import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.ToJson;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ApiJson<T> {
    private static final Moshi MOSHI = new Moshi.Builder().add((Object)new OffsetDateTimeAdapter()).add((Object)new LocalDateAdapter()).add((JsonAdapter.Factory)new ImmutableAdapterFactory()).build();
    private final JsonAdapter<T> adapter;
    private final Class<T> type;
    private JsonAdapter<Map<String, List<T>>> wrappedListAdapter;
    private JsonAdapter<List<T>> listAdapter;

    public ApiJson(Class<T> type) {
        this.adapter = MOSHI.adapter(type);
        this.type = type;
    }

    public String toJson(T t) {
        return this.adapter.toJson(t);
    }

    public String toPrettyJson(T t) {
        return this.adapter.indent("  ").toJson(t);
    }

    public T parse(String json) throws OnfidoException {
        return ApiJson.parse(this.adapter, json);
    }

    public List<T> parseWrappedList(String json, String path) throws OnfidoException {
        List<T> list;
        if (this.wrappedListAdapter == null) {
            ParameterizedType listType = Types.newParameterizedType(List.class, (Type[])new Type[]{this.type});
            ParameterizedType mapType = Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, listType});
            this.wrappedListAdapter = MOSHI.adapter((Type)mapType);
        }
        if ((list = ApiJson.parse(this.wrappedListAdapter, json).get(path)) == null) {
            throw new OnfidoException("Expected response to contain " + path, null);
        }
        return list;
    }

    public List<T> parseList(String json) throws OnfidoException {
        List<T> list;
        if (this.listAdapter == null) {
            ParameterizedType listType = Types.newParameterizedType(List.class, (Type[])new Type[]{this.type});
            this.listAdapter = MOSHI.adapter((Type)listType);
        }
        if ((list = ApiJson.parse(this.listAdapter, json)) == null) {
            throw new OnfidoException("Expected response to contain a list of items", null);
        }
        return list;
    }

    private static <T> T parse(JsonAdapter<T> adapter, String json) throws OnfidoException {
        try {
            return (T)adapter.fromJson(json);
        }
        catch (IOException e) {
            throw new OnfidoException("Error parsing JSON in response", e);
        }
    }

    private static final class ImmutableAdapterFactory
    implements JsonAdapter.Factory {
        private ImmutableAdapterFactory() {
        }

        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            Class rawType = Types.getRawType((Type)type);
            if (!annotations.isEmpty() || !rawType.equals(List.class) && !rawType.equals(Map.class)) {
                return null;
            }
            final JsonAdapter adapter = moshi.nextAdapter((JsonAdapter.Factory)this, type, annotations);
            return new JsonAdapter<Object>(){

                public Object fromJson(JsonReader reader) throws IOException {
                    Object value = adapter.fromJson(reader);
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof List) {
                        return Collections.unmodifiableList((List)value);
                    }
                    return Collections.unmodifiableMap((Map)value);
                }

                public void toJson(JsonWriter writer, Object value) throws IOException {
                    adapter.toJson(writer, value);
                }
            };
        }
    }

    private static final class OffsetDateTimeAdapter {
        private OffsetDateTimeAdapter() {
        }

        @ToJson
        String toJson(OffsetDateTime dateTime) {
            return dateTime == null ? null : dateTime.toString();
        }

        @FromJson
        OffsetDateTime fromJson(String dateTimeString) {
            return dateTimeString == null ? null : OffsetDateTime.parse(dateTimeString);
        }
    }

    private static final class LocalDateAdapter {
        private LocalDateAdapter() {
        }

        @ToJson
        String toJson(LocalDate date) {
            return date == null ? null : date.toString();
        }

        @FromJson
        LocalDate fromJson(String dateString) {
            return dateString == null || dateString.isEmpty() ? null : LocalDate.parse(dateString);
        }
    }
}

