/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.exceptions;

import com.onfido.exceptions.ErrorJson;
import com.onfido.exceptions.OnfidoException;
import java.util.Map;

public final class ApiException
extends OnfidoException {
    private static final long serialVersionUID = 1L;
    private int statusCode;
    private final String type;
    private final Map<String, Object> fields;

    private ApiException(String message, int statusCode, String type, Map<String, Object> fields) {
        super(message, null);
        this.statusCode = statusCode;
        this.type = type;
        this.fields = fields;
    }

    public static ApiException fromResponseBody(String body, int statusCode) {
        ErrorJson error = ErrorJson.fromJson(body);
        return new ApiException(error.getMessage(), statusCode, error.getType(), error.getFields());
    }

    @Override
    public String getMessage() {
        String message = String.format("%s (status code %d)", super.getMessage(), this.statusCode);
        if (this.fields.size() == 0) {
            return message;
        }
        return String.format("%s | Field errors: %s", message, this.fields);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isClientError() {
        return this.statusCode < 500;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }
}

