/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.models;

import com.onfido.api.ApiJson;
import com.onfido.models.DrivingLicence;
import com.squareup.moshi.Json;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public final class Check {
    private static final ApiJson<Check> JSON = new ApiJson<Check>(Check.class);
    @Json(name="id")
    private final String id;
    @Json(name="created_at")
    private final OffsetDateTime createdAt = null;
    @Json(name="href")
    private final String href;
    @Json(name="status")
    private final String status;
    @Json(name="result")
    private final String result;
    @Json(name="download_uri")
    private final String downloadUri;
    @Json(name="form_uri")
    private final String formUri;
    @Json(name="redirect_uri")
    private final String redirectUri;
    @Json(name="results_uri")
    private final String resultsUri;
    @Json(name="tags")
    private final List<String> tags = null;
    @Json(name="applicant_id")
    private final String applicantId;
    @Json(name="report_ids")
    private final List<String> reportIds = null;
    @Json(name="privacy_notices_read_consent_given")
    private final Boolean privacyNoticesReadConsentGiven = null;
    @Json(name="webhook_ids")
    private final List<String> webhookIds = null;

    private Check() {
        this.id = null;
        this.href = null;
        this.status = null;
        this.result = null;
        this.downloadUri = null;
        this.formUri = null;
        this.redirectUri = null;
        this.resultsUri = null;
        this.applicantId = null;
    }

    public static Request request() {
        return new Request();
    }

    public String getId() {
        return this.id;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getHref() {
        return this.href;
    }

    public String getStatus() {
        return this.status;
    }

    public String getResult() {
        return this.result;
    }

    public String getDownloadUri() {
        return this.downloadUri;
    }

    public String getFormUri() {
        return this.formUri;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getResultsUri() {
        return this.resultsUri;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getApplicantId() {
        return this.applicantId;
    }

    public List<String> getReportIds() {
        return this.reportIds;
    }

    public Boolean getPrivacyNoticesReadConsentGiven() {
        return this.privacyNoticesReadConsentGiven;
    }

    public List<String> getWebhookIds() {
        return this.webhookIds;
    }

    public String toString() {
        return "Check " + JSON.toPrettyJson(this);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.href, this.status, this.result, this.downloadUri, this.formUri, this.redirectUri, this.resultsUri, this.tags, this.applicantId, this.reportIds, this.privacyNoticesReadConsentGiven, this.webhookIds, "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Check other = (Check)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.href, other.href) && Objects.equals(this.status, other.status) && Objects.equals(this.result, other.result) && Objects.equals(this.downloadUri, other.downloadUri) && Objects.equals(this.formUri, other.formUri) && Objects.equals(this.redirectUri, other.redirectUri) && Objects.equals(this.resultsUri, other.resultsUri) && Objects.equals(this.tags, other.tags) && Objects.equals(this.applicantId, other.applicantId) && Objects.equals(this.reportIds, other.reportIds) && Objects.equals(this.privacyNoticesReadConsentGiven, other.privacyNoticesReadConsentGiven) && Objects.equals(this.webhookIds, other.webhookIds);
    }

    public static final class Request {
        private static final ApiJson<Request> REQUEST_JSON = new ApiJson<Request>(Request.class);
        @Json(name="redirect_uri")
        private String redirectUri;
        @Json(name="report_names")
        private String[] reportNames;
        @Json(name="document_ids")
        private String[] documentIds;
        @Json(name="tags")
        private String[] tags;
        @Json(name="applicant_provides_data")
        private Boolean applicantProvidesData;
        @Json(name="suppress_form_emails")
        private Boolean suppressFormEmails;
        @Json(name="asynchronous")
        private Boolean asynchronous;
        @Json(name="applicant_id")
        private String applicantId;
        @Json(name="privacy_notices_read_consent_given")
        private Boolean privacyNoticesReadConsentGiven;
        @Json(name="webhook_ids")
        private String[] webhookIds;
        @Json(name="sub_result")
        private String subResult;
        @Json(name="consider")
        private String[] consider;
        @Json(name="us_driving_licence")
        private DrivingLicence.Request usDrivingLicence;

        private Request() {
        }

        public String toJson() {
            return REQUEST_JSON.toJson(this);
        }

        public String toString() {
            return this.toJson();
        }

        public Request redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Request reportNames(List<String> reportNames) {
            this.reportNames = reportNames.toArray(new String[0]);
            return this;
        }

        public Request reportNames(String ... reportNames) {
            this.reportNames = reportNames;
            return this;
        }

        public Request documentIds(List<String> documentIds) {
            this.documentIds = documentIds.toArray(new String[0]);
            return this;
        }

        public Request documentIds(String ... documentIds) {
            this.documentIds = documentIds;
            return this;
        }

        public Request tags(List<String> tags) {
            this.tags = tags.toArray(new String[0]);
            return this;
        }

        public Request tags(String ... tags) {
            this.tags = tags;
            return this;
        }

        public Request applicantProvidesData(Boolean applicantProvidesData) {
            this.applicantProvidesData = applicantProvidesData;
            return this;
        }

        public Request suppressFormEmails(Boolean suppressFormEmails) {
            this.suppressFormEmails = suppressFormEmails;
            return this;
        }

        public Request asynchronous(Boolean asynchronous) {
            this.asynchronous = asynchronous;
            return this;
        }

        public Request applicantId(String applicantId) {
            this.applicantId = applicantId;
            return this;
        }

        public Request privacyNoticesReadConsentGiven(Boolean privacyNoticesReadConsentGiven) {
            this.privacyNoticesReadConsentGiven = privacyNoticesReadConsentGiven;
            return this;
        }

        public Request webhookIds(List<String> webhookIds) {
            this.webhookIds = webhookIds.toArray(new String[0]);
            return this;
        }

        public Request webhookIds(String ... webhookIds) {
            this.webhookIds = webhookIds;
            return this;
        }

        public Request subResult(String subResult) {
            this.subResult = subResult;
            return this;
        }

        public Request consider(List<String> consider) {
            this.consider = consider.toArray(new String[0]);
            return this;
        }

        public Request consider(String ... consider) {
            this.consider = consider;
            return this;
        }

        public Request usDrivingLicence(DrivingLicence.Request usDrivingLicence) {
            this.usDrivingLicence = usDrivingLicence;
            return this;
        }

        public String getRedirectUri() {
            return this.redirectUri;
        }

        public String[] getReportNames() {
            return this.reportNames;
        }

        public String[] getDocumentIds() {
            return this.documentIds;
        }

        public String[] getTags() {
            return this.tags;
        }

        public Boolean getApplicantProvidesData() {
            return this.applicantProvidesData;
        }

        public Boolean getSuppressFormEmails() {
            return this.suppressFormEmails;
        }

        public Boolean getAsynchronous() {
            return this.asynchronous;
        }

        public String getApplicantId() {
            return this.applicantId;
        }

        public Boolean getPrivacyNoticesReadConsentGiven() {
            return this.privacyNoticesReadConsentGiven;
        }

        public String[] getWebhookIds() {
            return this.webhookIds;
        }

        public String getSubResult() {
            return this.subResult;
        }

        public String[] getConsider() {
            return this.consider;
        }

        public DrivingLicence.Request getUsDrivingLicence() {
            return this.usDrivingLicence;
        }
    }
}

