/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.models;

import com.onfido.api.ApiJson;
import com.onfido.models.DocumentClassification;
import com.onfido.models.ExtractedData;
import com.squareup.moshi.Json;
import java.util.Objects;

public final class Extraction {
    private static final ApiJson<Extraction> JSON = new ApiJson<Extraction>(Extraction.class);
    @Json(name="document_id")
    private final String documentId;
    @Json(name="document_classification")
    private final DocumentClassification documentClassification = null;
    @Json(name="extracted_data")
    private final ExtractedData extractedData = null;

    private Extraction() {
        this.documentId = null;
    }

    public static Request request() {
        return new Request();
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public DocumentClassification getDocumentClassification() {
        return this.documentClassification;
    }

    public ExtractedData getExtractedData() {
        return this.extractedData;
    }

    public String toString() {
        return "Extraction " + JSON.toPrettyJson(this);
    }

    public int hashCode() {
        return Objects.hash(this.documentId, this.documentClassification, this.extractedData, "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extraction other = (Extraction)o;
        return Objects.equals(this.documentId, other.documentId) && Objects.equals(this.documentClassification, other.documentClassification) && Objects.equals(this.extractedData, other.extractedData);
    }

    public static final class Request {
        private static final ApiJson<Request> REQUEST_JSON = new ApiJson<Request>(Request.class);

        private Request() {
        }

        public String toJson() {
            return REQUEST_JSON.toJson(this);
        }

        public String toString() {
            return this.toJson();
        }
    }
}

