/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.models;

import com.onfido.api.ApiJson;
import com.squareup.moshi.Json;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class LivePhoto {
    private static final ApiJson<LivePhoto> JSON = new ApiJson<LivePhoto>(LivePhoto.class);
    @Json(name="id")
    private final String id;
    @Json(name="created_at")
    private final OffsetDateTime createdAt = null;
    @Json(name="href")
    private final String href;
    @Json(name="download_href")
    private final String downloadHref;
    @Json(name="file_name")
    private final String fileName;
    @Json(name="file_size")
    private final int fileSize;
    @Json(name="file_type")
    private final String fileType;
    @Json(name="applicant_id")
    private final String applicantId;
    @Json(name="advanced_validation")
    private final boolean advancedValidation;

    private LivePhoto() {
        this.id = null;
        this.href = null;
        this.downloadHref = null;
        this.fileName = null;
        this.fileSize = 0;
        this.fileType = null;
        this.applicantId = null;
        this.advancedValidation = false;
    }

    public static Request request() {
        return new Request();
    }

    public String getId() {
        return this.id;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getHref() {
        return this.href;
    }

    public String getDownloadHref() {
        return this.downloadHref;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getApplicantId() {
        return this.applicantId;
    }

    public boolean getAdvancedValidation() {
        return this.advancedValidation;
    }

    public String toString() {
        return "LivePhoto " + JSON.toPrettyJson(this);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.href, this.downloadHref, this.fileName, this.fileSize, this.fileType, this.applicantId, this.advancedValidation, "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LivePhoto other = (LivePhoto)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.href, other.href) && Objects.equals(this.downloadHref, other.downloadHref) && Objects.equals(this.fileName, other.fileName) && Objects.equals(this.fileSize, other.fileSize) && Objects.equals(this.fileType, other.fileType) && Objects.equals(this.applicantId, other.applicantId) && Objects.equals(this.advancedValidation, other.advancedValidation);
    }

    public static final class Request {
        private static final ApiJson<Request> REQUEST_JSON = new ApiJson<Request>(Request.class);
        @Json(name="applicant_id")
        private String applicantId;
        @Json(name="advanced_validation")
        private Boolean advancedValidation;

        private Request() {
        }

        public String toJson() {
            return REQUEST_JSON.toJson(this);
        }

        public String toString() {
            return this.toJson();
        }

        public Request applicantId(String applicantId) {
            this.applicantId = applicantId;
            return this;
        }

        public Request advancedValidation(Boolean advancedValidation) {
            this.advancedValidation = advancedValidation;
            return this;
        }

        public String getApplicantId() {
            return this.applicantId;
        }

        public Boolean getAdvancedValidation() {
            return this.advancedValidation;
        }
    }
}

