/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.models;

import com.onfido.api.ApiJson;
import com.onfido.models.DocumentId;
import com.squareup.moshi.Json;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Report {
    private static final ApiJson<Report> JSON = new ApiJson<Report>(Report.class);
    @Json(name="id")
    private final String id;
    @Json(name="created_at")
    private final OffsetDateTime createdAt = null;
    @Json(name="name")
    private final String name;
    @Json(name="status")
    private final String status;
    @Json(name="href")
    private final String href;
    @Json(name="result")
    private final String result;
    @Json(name="sub_result")
    private final String subResult;
    @Json(name="properties")
    private final Map<String, Object> properties = null;
    @Json(name="breakdown")
    private final Map<String, Object> breakdown = null;
    @Json(name="documents")
    private final List<DocumentId> documents = null;
    @Json(name="check_id")
    private final String checkId;

    private Report() {
        this.id = null;
        this.name = null;
        this.status = null;
        this.href = null;
        this.result = null;
        this.subResult = null;
        this.checkId = null;
    }

    public static Request request() {
        return new Request();
    }

    public String getId() {
        return this.id;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public String getHref() {
        return this.href;
    }

    public String getResult() {
        return this.result;
    }

    public String getSubResult() {
        return this.subResult;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, Object> getBreakdown() {
        return this.breakdown;
    }

    public List<DocumentId> getDocuments() {
        return this.documents;
    }

    public String getCheckId() {
        return this.checkId;
    }

    public String toString() {
        return "Report " + JSON.toPrettyJson(this);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.name, this.status, this.href, this.result, this.subResult, this.properties, this.breakdown, this.documents, this.checkId, "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Report other = (Report)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.name, other.name) && Objects.equals(this.status, other.status) && Objects.equals(this.href, other.href) && Objects.equals(this.result, other.result) && Objects.equals(this.subResult, other.subResult) && Objects.equals(this.properties, other.properties) && Objects.equals(this.breakdown, other.breakdown) && Objects.equals(this.documents, other.documents) && Objects.equals(this.checkId, other.checkId);
    }

    public static final class Request {
        private static final ApiJson<Request> REQUEST_JSON = new ApiJson<Request>(Request.class);
        @Json(name="name")
        private String name;
        @Json(name="result")
        private String result;

        private Request() {
        }

        public String toJson() {
            return REQUEST_JSON.toJson(this);
        }

        public String toString() {
            return this.toJson();
        }

        public Request name(String name) {
            this.name = name;
            return this;
        }

        public Request result(String result) {
            this.result = result;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public String getResult() {
            return this.result;
        }
    }
}

