/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.models;

import com.onfido.api.ApiJson;
import com.squareup.moshi.Json;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;

public final class Task {
    private static final ApiJson<Task> JSON = new ApiJson<Task>(Task.class);
    @Json(name="created_at")
    private final OffsetDateTime createdAt = null;
    @Json(name="id")
    private final String id;
    @Json(name="task_def_id")
    private final String taskDefId;
    @Json(name="task_def_version")
    private final String taskDefVersion;
    @Json(name="updated_at")
    private final OffsetDateTime updatedAt = null;
    @Json(name="workflow_run_id")
    private final String workflowRunId;
    @Json(name="input")
    private final Map<String, Object> input = null;
    @Json(name="output")
    private final Map<String, Object> output = null;

    private Task() {
        this.id = null;
        this.taskDefId = null;
        this.taskDefVersion = null;
        this.workflowRunId = null;
    }

    public static Request request() {
        return new Request();
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getId() {
        return this.id;
    }

    public String getTaskDefId() {
        return this.taskDefId;
    }

    public String getTaskDefVersion() {
        return this.taskDefVersion;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public String getWorkflowRunId() {
        return this.workflowRunId;
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    public Map<String, Object> getOutput() {
        return this.output;
    }

    public String toString() {
        return "Task " + JSON.toPrettyJson(this);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.id, this.taskDefId, this.taskDefVersion, this.updatedAt, this.workflowRunId, this.input, this.output, "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task other = (Task)o;
        return Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.id, other.id) && Objects.equals(this.taskDefId, other.taskDefId) && Objects.equals(this.taskDefVersion, other.taskDefVersion) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.workflowRunId, other.workflowRunId) && Objects.equals(this.input, other.input) && Objects.equals(this.output, other.output);
    }

    public static final class Request {
        private static final ApiJson<Request> REQUEST_JSON = new ApiJson<Request>(Request.class);
        @Json(name="task_def_id")
        private String taskDefId;
        @Json(name="task_def_version")
        private String taskDefVersion;
        @Json(name="workflow_run_id")
        private String workflowRunId;

        private Request() {
        }

        public String toJson() {
            return REQUEST_JSON.toJson(this);
        }

        public String toString() {
            return this.toJson();
        }

        public Request taskDefId(String taskDefId) {
            this.taskDefId = taskDefId;
            return this;
        }

        public Request taskDefVersion(String taskDefVersion) {
            this.taskDefVersion = taskDefVersion;
            return this;
        }

        public Request workflowRunId(String workflowRunId) {
            this.workflowRunId = workflowRunId;
            return this;
        }

        public String getTaskDefId() {
            return this.taskDefId;
        }

        public String getTaskDefVersion() {
            return this.taskDefVersion;
        }

        public String getWorkflowRunId() {
            return this.workflowRunId;
        }
    }
}

