/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.models;

import com.onfido.api.ApiJson;
import com.squareup.moshi.Json;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class WorkflowRun {
    private static final ApiJson<WorkflowRun> JSON = new ApiJson<WorkflowRun>(WorkflowRun.class);
    @Json(name="id")
    private final String id;
    @Json(name="applicant_id")
    private final String applicantId;
    @Json(name="workflow_id")
    private final String workflowId;
    @Json(name="workflow_version_id")
    private final String workflowVersionId;
    @Json(name="status")
    private final String status;
    @Json(name="dashboard_url")
    private final String dashboardUrl;
    @Json(name="output")
    private final Map<String, Object> output = null;
    @Json(name="reasons")
    private final List<String> reasons = null;
    @Json(name="error")
    private final Map<String, Object> error = null;
    @Json(name="link")
    private final Map<String, Object> link = null;
    @Json(name="created_at")
    private final OffsetDateTime createdAt = null;
    @Json(name="updated_at")
    private final OffsetDateTime updatedAt = null;
    @Json(name="tags")
    private final List<String> tags = null;

    private WorkflowRun() {
        this.id = null;
        this.applicantId = null;
        this.workflowId = null;
        this.workflowVersionId = null;
        this.status = null;
        this.dashboardUrl = null;
    }

    public static Request request() {
        return new Request();
    }

    public String getId() {
        return this.id;
    }

    public String getApplicantId() {
        return this.applicantId;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public String getWorkflowVersionId() {
        return this.workflowVersionId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    public Map<String, Object> getOutput() {
        return this.output;
    }

    public List<String> getReasons() {
        return this.reasons;
    }

    public Map<String, Object> getError() {
        return this.error;
    }

    public Map<String, Object> getLink() {
        return this.link;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "WorkflowRun " + JSON.toPrettyJson(this);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.applicantId, this.workflowId, this.workflowVersionId, this.status, this.dashboardUrl, this.output, this.reasons, this.error, this.link, this.createdAt, this.updatedAt, this.tags, "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowRun other = (WorkflowRun)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.applicantId, other.applicantId) && Objects.equals(this.workflowId, other.workflowId) && Objects.equals(this.workflowVersionId, other.workflowVersionId) && Objects.equals(this.status, other.status) && Objects.equals(this.dashboardUrl, other.dashboardUrl) && Objects.equals(this.output, other.output) && Objects.equals(this.reasons, other.reasons) && Objects.equals(this.error, other.error) && Objects.equals(this.link, other.link) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.tags, other.tags);
    }

    public static final class Request {
        private static final ApiJson<Request> REQUEST_JSON = new ApiJson<Request>(Request.class);
        @Json(name="applicant_id")
        private String applicantId;
        @Json(name="workflow_id")
        private String workflowId;
        @Json(name="link")
        private Map<String, Object> link;
        @Json(name="custom_data")
        private Map<String, Object> customData;
        @Json(name="tags")
        private String[] tags;

        private Request() {
        }

        public String toJson() {
            return REQUEST_JSON.toJson(this);
        }

        public String toString() {
            return this.toJson();
        }

        public Request applicantId(String applicantId) {
            this.applicantId = applicantId;
            return this;
        }

        public Request workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public Request link(Map<String, Object> link) {
            this.link = link;
            return this;
        }

        public Request customData(Map<String, Object> customData) {
            this.customData = customData;
            return this;
        }

        public Request tags(List<String> tags) {
            this.tags = tags.toArray(new String[0]);
            return this;
        }

        public Request tags(String ... tags) {
            this.tags = tags;
            return this;
        }

        public String getApplicantId() {
            return this.applicantId;
        }

        public String getWorkflowId() {
            return this.workflowId;
        }

        public Map<String, Object> getLink() {
            return this.link;
        }

        public Map<String, Object> getCustomData() {
            return this.customData;
        }

        public String[] getTags() {
            return this.tags;
        }
    }
}

