/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.webhooks;

import com.onfido.api.ApiJson;
import com.onfido.exceptions.OnfidoException;
import com.onfido.webhooks.WebhookEvent;
import com.onfido.webhooks.WebhookPayload;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class WebhookEventVerifier {
    private ApiJson<WebhookPayload> parser = new ApiJson<WebhookPayload>(WebhookPayload.class);
    private final String webhookToken;

    public WebhookEventVerifier(String webhookToken) {
        this.webhookToken = webhookToken;
    }

    public WebhookEvent readPayload(String rawEventBody, String hexSignature) throws OnfidoException {
        Mac sha256Hmac;
        try {
            sha256Hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(this.webhookToken.getBytes(), "HmacSHA256");
            sha256Hmac.init(secretKey);
        }
        catch (Exception ex) {
            throw new OnfidoException("Invalid webhook token", ex);
        }
        String eventSignature = new String(Hex.encodeHex((byte[])sha256Hmac.doFinal(rawEventBody.getBytes(StandardCharsets.UTF_8))));
        if (!MessageDigest.isEqual(eventSignature.getBytes(), hexSignature.getBytes())) {
            throw new OnfidoException("Invalid signature for webhook event");
        }
        return this.parser.parse(rawEventBody).getPayload();
    }
}

