/*
 * Decompiled with CFR 0.152.
 */
package com.onfido;

import com.onfido.AddressManager;
import com.onfido.ApplicantManager;
import com.onfido.CheckManager;
import com.onfido.DocumentManager;
import com.onfido.ExtractionManager;
import com.onfido.LivePhotoManager;
import com.onfido.LiveVideoManager;
import com.onfido.ReportManager;
import com.onfido.SdkTokenManager;
import com.onfido.WebhookManager;
import com.onfido.api.Config;
import java.net.Proxy;
import java.time.Duration;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public final class Onfido {
    private static final OkHttpClient CLIENT = new OkHttpClient();
    private static final String EU_API_URL = "https://api.eu.onfido.com/v3.4/";
    private static final String US_API_URL = "https://api.us.onfido.com/v3.4/";
    private static final String CA_API_URL = "https://api.ca.onfido.com/v3.4/";
    public final Config config;
    public final ApplicantManager applicant;
    public final DocumentManager document;
    public final CheckManager check;
    public final ReportManager report;
    public final LivePhotoManager livePhoto;
    public final LiveVideoManager liveVideo;
    public final AddressManager address;
    public final SdkTokenManager sdkToken;
    public final WebhookManager webhook;
    public final ExtractionManager extraction;

    private Onfido(Builder builder) {
        this.config = new Config(builder);
        OkHttpClient.Builder clientBuilder = CLIENT.newBuilder();
        if (builder.clientInterceptor != null) {
            clientBuilder.addInterceptor(builder.clientInterceptor);
        }
        if (builder.httpClientReadTimeout != null) {
            clientBuilder.readTimeout(builder.httpClientReadTimeout);
        }
        if (builder.httpClientProxy != null) {
            clientBuilder.proxy(builder.httpClientProxy);
        }
        OkHttpClient client = clientBuilder.build();
        this.applicant = new ApplicantManager(this.config, client);
        this.document = new DocumentManager(this.config, client);
        this.check = new CheckManager(this.config, client);
        this.report = new ReportManager(this.config, client);
        this.livePhoto = new LivePhotoManager(this.config, client);
        this.liveVideo = new LiveVideoManager(this.config, client);
        this.address = new AddressManager(this.config, client);
        this.sdkToken = new SdkTokenManager(this.config, client);
        this.webhook = new WebhookManager(this.config, client);
        this.extraction = new ExtractionManager(this.config, client);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void shutdown() {
        CLIENT.dispatcher().executorService().shutdown();
        CLIENT.connectionPool().evictAll();
    }

    public static final class Builder {
        public String apiToken = "";
        public String apiUrl = "";
        private Interceptor clientInterceptor;
        private Duration httpClientReadTimeout = Duration.ofSeconds(30L);
        private Proxy httpClientProxy;

        private Builder() {
        }

        public Onfido build() {
            if (this.apiToken == null || this.apiToken.isEmpty()) {
                throw new RuntimeException("Please provide an apiToken");
            }
            if (this.apiUrl == null || this.apiUrl.isEmpty()) {
                throw new RuntimeException("Please specify a region with .regionEU(), .regionUS(), or .regionCA(). We previously defaulted to the EU region, so if you previously didn\u2019t set a region or used api.onfido.com, please set your region using .regionEU()");
            }
            return new Onfido(this);
        }

        public Builder apiToken(String apiToken) {
            this.apiToken = apiToken;
            return this;
        }

        public Builder clientInterceptor(Interceptor interceptor) {
            this.clientInterceptor = interceptor;
            return this;
        }

        public Builder clientReadTimeout(Duration readTimeout) {
            this.httpClientReadTimeout = readTimeout;
            return this;
        }

        public Builder clientProxy(Proxy proxy) {
            this.httpClientProxy = proxy;
            return this;
        }

        public Builder regionEU() {
            this.apiUrl = Onfido.EU_API_URL;
            return this;
        }

        public Builder regionUS() {
            this.apiUrl = Onfido.US_API_URL;
            return this;
        }

        public Builder regionCA() {
            this.apiUrl = Onfido.CA_API_URL;
            return this;
        }

        public Builder unknownApiUrl(String url) {
            this.apiUrl = url;
            return this;
        }
    }
}

