/*
 * Decompiled with CFR 0.152.
 */
package com.onfido;

import com.onfido.api.ApiJson;
import com.onfido.api.Config;
import com.onfido.api.ResourceManager;
import com.onfido.exceptions.OnfidoException;
import com.onfido.models.Report;
import java.util.List;
import okhttp3.OkHttpClient;

public class ReportManager
extends ResourceManager {
    private ApiJson<Report> reportParser = new ApiJson<Report>(Report.class);

    protected ReportManager(Config config, OkHttpClient client) {
        super("reports/", config, client);
    }

    public Report find(String reportId) throws OnfidoException {
        return this.reportParser.parse(this.get(reportId));
    }

    public List<Report> list(String checkId) throws OnfidoException {
        return this.reportParser.parseWrappedList(this.get("?check_id=" + checkId), "reports");
    }

    public void resume(String reportId) throws OnfidoException {
        this.post(reportId + "/resume", "");
    }

    public void cancel(String reportId) throws OnfidoException {
        this.post(reportId + "/cancel", "");
    }
}

