/*
 * Decompiled with CFR 0.152.
 */
package com.onfido;

import com.onfido.api.ApiJson;
import com.onfido.api.Config;
import com.onfido.api.ResourceManager;
import com.onfido.exceptions.OnfidoException;
import com.onfido.models.Webhook;
import java.util.List;
import okhttp3.OkHttpClient;

public class WebhookManager
extends ResourceManager {
    private ApiJson<Webhook> webhookParser = new ApiJson<Webhook>(Webhook.class);
    private ApiJson<Webhook.Request> requestFormatter = new ApiJson<Webhook.Request>(Webhook.Request.class);

    protected WebhookManager(Config config, OkHttpClient client) {
        super("webhooks/", config, client);
    }

    public Webhook create(Webhook.Request request) throws OnfidoException {
        return this.webhookParser.parse(this.post("", this.requestFormatter.toJson(request)));
    }

    public Webhook find(String webhookId) throws OnfidoException {
        return this.webhookParser.parse(this.get(webhookId));
    }

    public Webhook update(String webhookId, Webhook.Request request) throws OnfidoException {
        return this.webhookParser.parse(this.put(webhookId, this.requestFormatter.toJson(request)));
    }

    public void delete(String webhookId) throws OnfidoException {
        this.deleteRequest(webhookId);
    }

    public List<Webhook> list() throws OnfidoException {
        return this.webhookParser.parseWrappedList(this.get(""), "webhooks");
    }
}

