/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.api;

import com.onfido.api.Config;
import com.onfido.api.FileDownload;
import com.onfido.exceptions.ApiException;
import com.onfido.exceptions.OnfidoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class ResourceManager {
    private final OkHttpClient client;
    private final Config config;
    private final String basePath;
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");

    protected ResourceManager(String basePath, Config config, OkHttpClient client) {
        this.basePath = basePath;
        this.config = config;
        this.client = client;
    }

    protected String post(String path, String body) throws OnfidoException {
        Request request = this.requestBuilder(path).post(RequestBody.create((String)body, (MediaType)JSON)).build();
        return this.performRequest(request);
    }

    protected String get(String path) throws OnfidoException {
        Request request = this.requestBuilder(path).build();
        return this.performRequest(request);
    }

    protected String put(String path, String body) throws OnfidoException {
        Request request = this.requestBuilder(path).put(RequestBody.create((String)body, (MediaType)JSON)).build();
        return this.performRequest(request);
    }

    protected String deleteRequest(String path) throws OnfidoException {
        Request request = this.requestBuilder(path).delete().build();
        return this.performRequest(request);
    }

    protected String uploadRequest(String path, RequestBody body) throws OnfidoException {
        Request request = this.requestBuilder(path).post(body).build();
        return this.performRequest(request);
    }

    protected FileDownload downloadRequest(String path) throws OnfidoException {
        Request request = this.requestBuilder(path).get().build();
        return this.performDownload(request);
    }

    protected byte[] readInputStream(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    protected void addFormDataParam(MultipartBody.Builder builder, String key, Object value) {
        if (value != null) {
            builder.addFormDataPart(key, value.toString());
        }
    }

    private Request.Builder requestBuilder(String path) {
        String version = this.getClass().getPackage().getImplementationVersion();
        return new Request.Builder().url(this.config.getApiUrl() + this.basePath + path).header("Authorization", "Token token=" + this.config.getApiToken()).header("User-Agent", "onfido-java/" + version).header("Accept", "application/json");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String performRequest(Request request) throws OnfidoException {
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) throw ApiException.fromResponseBody(response.body().string(), response.code());
            String string = response.body().string();
            return string;
        }
        catch (IOException e) {
            throw OnfidoException.networkError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileDownload performDownload(Request request) throws OnfidoException {
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) throw ApiException.fromResponseBody(response.body().string(), response.code());
            FileDownload fileDownload = new FileDownload(response.body().bytes(), response.header("content-type"));
            return fileDownload;
        }
        catch (IOException e) {
            throw OnfidoException.networkError(e);
        }
    }
}

