/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.models;

import com.onfido.api.ApiJson;
import com.squareup.moshi.Json;
import java.util.Objects;

public final class Address {
    private static final ApiJson<Address> JSON = new ApiJson<Address>(Address.class);
    @Json(name="flat_number")
    private final String flatNumber;
    @Json(name="building_number")
    private final String buildingNumber;
    @Json(name="building_name")
    private final String buildingName;
    @Json(name="street")
    private final String street;
    @Json(name="sub_street")
    private final String subStreet;
    @Json(name="town")
    private final String town;
    @Json(name="postcode")
    private final String postcode;
    @Json(name="country")
    private final String country;
    @Json(name="state")
    private final String state;
    @Json(name="line1")
    private final String line1;
    @Json(name="line2")
    private final String line2;
    @Json(name="line3")
    private final String line3;

    private Address() {
        this.flatNumber = null;
        this.buildingNumber = null;
        this.buildingName = null;
        this.street = null;
        this.subStreet = null;
        this.town = null;
        this.postcode = null;
        this.country = null;
        this.state = null;
        this.line1 = null;
        this.line2 = null;
        this.line3 = null;
    }

    public static Request request() {
        return new Request();
    }

    public String getFlatNumber() {
        return this.flatNumber;
    }

    public String getBuildingNumber() {
        return this.buildingNumber;
    }

    public String getBuildingName() {
        return this.buildingName;
    }

    public String getStreet() {
        return this.street;
    }

    public String getSubStreet() {
        return this.subStreet;
    }

    public String getTown() {
        return this.town;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public String getCountry() {
        return this.country;
    }

    public String getState() {
        return this.state;
    }

    public String getLine1() {
        return this.line1;
    }

    public String getLine2() {
        return this.line2;
    }

    public String getLine3() {
        return this.line3;
    }

    public String toString() {
        return "Address " + JSON.toPrettyJson(this);
    }

    public int hashCode() {
        return Objects.hash(this.flatNumber, this.buildingNumber, this.buildingName, this.street, this.subStreet, this.town, this.postcode, this.country, this.state, this.line1, this.line2, this.line3, "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address other = (Address)o;
        return Objects.equals(this.flatNumber, other.flatNumber) && Objects.equals(this.buildingNumber, other.buildingNumber) && Objects.equals(this.buildingName, other.buildingName) && Objects.equals(this.street, other.street) && Objects.equals(this.subStreet, other.subStreet) && Objects.equals(this.town, other.town) && Objects.equals(this.postcode, other.postcode) && Objects.equals(this.country, other.country) && Objects.equals(this.state, other.state) && Objects.equals(this.line1, other.line1) && Objects.equals(this.line2, other.line2) && Objects.equals(this.line3, other.line3);
    }

    public static final class Request {
        private static final ApiJson<Request> REQUEST_JSON = new ApiJson<Request>(Request.class);
        @Json(name="flat_number")
        private String flatNumber;
        @Json(name="building_number")
        private String buildingNumber;
        @Json(name="building_name")
        private String buildingName;
        @Json(name="street")
        private String street;
        @Json(name="sub_street")
        private String subStreet;
        @Json(name="town")
        private String town;
        @Json(name="postcode")
        private String postcode;
        @Json(name="country")
        private String country;
        @Json(name="state")
        private String state;
        @Json(name="line1")
        private String line1;
        @Json(name="line2")
        private String line2;
        @Json(name="line3")
        private String line3;

        private Request() {
        }

        public String toJson() {
            return REQUEST_JSON.toJson(this);
        }

        public String toString() {
            return this.toJson();
        }

        public Request flatNumber(String flatNumber) {
            this.flatNumber = flatNumber;
            return this;
        }

        public Request buildingNumber(String buildingNumber) {
            this.buildingNumber = buildingNumber;
            return this;
        }

        public Request buildingName(String buildingName) {
            this.buildingName = buildingName;
            return this;
        }

        public Request street(String street) {
            this.street = street;
            return this;
        }

        public Request subStreet(String subStreet) {
            this.subStreet = subStreet;
            return this;
        }

        public Request town(String town) {
            this.town = town;
            return this;
        }

        public Request postcode(String postcode) {
            this.postcode = postcode;
            return this;
        }

        public Request country(String country) {
            this.country = country;
            return this;
        }

        public Request state(String state) {
            this.state = state;
            return this;
        }

        public Request line1(String line1) {
            this.line1 = line1;
            return this;
        }

        public Request line2(String line2) {
            this.line2 = line2;
            return this;
        }

        public Request line3(String line3) {
            this.line3 = line3;
            return this;
        }

        public String getFlatNumber() {
            return this.flatNumber;
        }

        public String getBuildingNumber() {
            return this.buildingNumber;
        }

        public String getBuildingName() {
            return this.buildingName;
        }

        public String getStreet() {
            return this.street;
        }

        public String getSubStreet() {
            return this.subStreet;
        }

        public String getTown() {
            return this.town;
        }

        public String getPostcode() {
            return this.postcode;
        }

        public String getCountry() {
            return this.country;
        }

        public String getState() {
            return this.state;
        }

        public String getLine1() {
            return this.line1;
        }

        public String getLine2() {
            return this.line2;
        }

        public String getLine3() {
            return this.line3;
        }
    }
}

