/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.models;

import com.onfido.api.ApiJson;
import com.onfido.models.Address;
import com.onfido.models.Consent;
import com.onfido.models.IdNumber;
import com.onfido.models.Location;
import com.squareup.moshi.Json;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public final class Applicant {
    private static final ApiJson<Applicant> JSON = new ApiJson<Applicant>(Applicant.class);
    @Json(name="id")
    private final String id;
    @Json(name="created_at")
    private final OffsetDateTime createdAt = null;
    @Json(name="delete_at")
    private final OffsetDateTime deleteAt = null;
    @Json(name="href")
    private final String href;
    @Json(name="sandbox")
    private final boolean sandbox;
    @Json(name="first_name")
    private final String firstName;
    @Json(name="last_name")
    private final String lastName;
    @Json(name="email")
    private final String email;
    @Json(name="dob")
    private final LocalDate dob = null;
    @Json(name="address")
    private final Address address = null;
    @Json(name="id_numbers")
    private final List<IdNumber> idNumbers = null;
    @Json(name="phone_number")
    private final String phoneNumber;
    @Json(name="location")
    private final Location location = null;

    private Applicant() {
        this.id = null;
        this.href = null;
        this.sandbox = false;
        this.firstName = null;
        this.lastName = null;
        this.email = null;
        this.phoneNumber = null;
    }

    public static Request request() {
        return new Request();
    }

    public String getId() {
        return this.id;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getDeleteAt() {
        return this.deleteAt;
    }

    public String getHref() {
        return this.href;
    }

    public boolean getSandbox() {
        return this.sandbox;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public LocalDate getDob() {
        return this.dob;
    }

    public Address getAddress() {
        return this.address;
    }

    public List<IdNumber> getIdNumbers() {
        return this.idNumbers;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return "Applicant " + JSON.toPrettyJson(this);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.deleteAt, this.href, this.sandbox, this.firstName, this.lastName, this.email, this.dob, this.address, this.idNumbers, this.phoneNumber, this.location, "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Applicant other = (Applicant)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.deleteAt, other.deleteAt) && Objects.equals(this.href, other.href) && Objects.equals(this.sandbox, other.sandbox) && Objects.equals(this.firstName, other.firstName) && Objects.equals(this.lastName, other.lastName) && Objects.equals(this.email, other.email) && Objects.equals(this.dob, other.dob) && Objects.equals(this.address, other.address) && Objects.equals(this.idNumbers, other.idNumbers) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.location, other.location);
    }

    public static final class Request {
        private static final ApiJson<Request> REQUEST_JSON = new ApiJson<Request>(Request.class);
        @Json(name="first_name")
        private String firstName;
        @Json(name="last_name")
        private String lastName;
        @Json(name="email")
        private String email;
        @Json(name="dob")
        private LocalDate dob;
        @Json(name="address")
        private Address.Request address;
        @Json(name="id_numbers")
        private IdNumber.Request[] idNumbers;
        @Json(name="phone_number")
        private String phoneNumber;
        @Json(name="location")
        private Location.Request location;
        @Json(name="consents")
        private Consent.Request[] consents;

        private Request() {
        }

        public String toJson() {
            return REQUEST_JSON.toJson(this);
        }

        public String toString() {
            return this.toJson();
        }

        public Request firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Request lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Request email(String email) {
            this.email = email;
            return this;
        }

        public Request dob(LocalDate dob) {
            this.dob = dob;
            return this;
        }

        public Request address(Address.Request address) {
            this.address = address;
            return this;
        }

        public Request idNumbers(List<IdNumber.Request> idNumbers) {
            this.idNumbers = idNumbers.toArray(new IdNumber.Request[0]);
            return this;
        }

        public Request idNumbers(IdNumber.Request ... idNumbers) {
            this.idNumbers = idNumbers;
            return this;
        }

        public Request phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Request location(Location.Request location) {
            this.location = location;
            return this;
        }

        public Request consents(List<Consent.Request> consents) {
            this.consents = consents.toArray(new Consent.Request[0]);
            return this;
        }

        public Request consents(Consent.Request ... consents) {
            this.consents = consents;
            return this;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getEmail() {
            return this.email;
        }

        public LocalDate getDob() {
            return this.dob;
        }

        public Address.Request getAddress() {
            return this.address;
        }

        public IdNumber.Request[] getIdNumbers() {
            return this.idNumbers;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public Location.Request getLocation() {
            return this.location;
        }

        public Consent.Request[] getConsents() {
            return this.consents;
        }
    }
}

