/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.models;

import com.onfido.api.ApiJson;
import com.onfido.models.Location;
import com.squareup.moshi.Json;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class Document {
    private static final ApiJson<Document> JSON = new ApiJson<Document>(Document.class);
    @Json(name="id")
    private final String id;
    @Json(name="created_at")
    private final OffsetDateTime createdAt = null;
    @Json(name="file_name")
    private final String fileName;
    @Json(name="file_size")
    private final int fileSize;
    @Json(name="file_type")
    private final String fileType;
    @Json(name="type")
    private final String type;
    @Json(name="side")
    private final String side;
    @Json(name="issuing_country")
    private final String issuingCountry;
    @Json(name="href")
    private final String href;
    @Json(name="download_href")
    private final String downloadHref;

    private Document() {
        this.id = null;
        this.fileName = null;
        this.fileSize = 0;
        this.fileType = null;
        this.type = null;
        this.side = null;
        this.issuingCountry = null;
        this.href = null;
        this.downloadHref = null;
    }

    public static Request request() {
        return new Request();
    }

    public String getId() {
        return this.id;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getType() {
        return this.type;
    }

    public String getSide() {
        return this.side;
    }

    public String getIssuingCountry() {
        return this.issuingCountry;
    }

    public String getHref() {
        return this.href;
    }

    public String getDownloadHref() {
        return this.downloadHref;
    }

    public String toString() {
        return "Document " + JSON.toPrettyJson(this);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.fileName, this.fileSize, this.fileType, this.type, this.side, this.issuingCountry, this.href, this.downloadHref, "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document other = (Document)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.fileName, other.fileName) && Objects.equals(this.fileSize, other.fileSize) && Objects.equals(this.fileType, other.fileType) && Objects.equals(this.type, other.type) && Objects.equals(this.side, other.side) && Objects.equals(this.issuingCountry, other.issuingCountry) && Objects.equals(this.href, other.href) && Objects.equals(this.downloadHref, other.downloadHref);
    }

    public static final class Request {
        private static final ApiJson<Request> REQUEST_JSON = new ApiJson<Request>(Request.class);
        @Json(name="applicant_id")
        private String applicantId;
        @Json(name="type")
        private String type;
        @Json(name="side")
        private String side;
        @Json(name="issuing_country")
        private String issuingCountry;
        @Json(name="validate_image_quality")
        private Boolean validateImageQuality;
        @Json(name="location")
        private Location.Request location;

        private Request() {
        }

        public String toJson() {
            return REQUEST_JSON.toJson(this);
        }

        public String toString() {
            return this.toJson();
        }

        public Request applicantId(String applicantId) {
            this.applicantId = applicantId;
            return this;
        }

        public Request type(String type) {
            this.type = type;
            return this;
        }

        public Request side(String side) {
            this.side = side;
            return this;
        }

        public Request issuingCountry(String issuingCountry) {
            this.issuingCountry = issuingCountry;
            return this;
        }

        public Request validateImageQuality(Boolean validateImageQuality) {
            this.validateImageQuality = validateImageQuality;
            return this;
        }

        public Request location(Location.Request location) {
            this.location = location;
            return this;
        }

        public String getApplicantId() {
            return this.applicantId;
        }

        public String getType() {
            return this.type;
        }

        public String getSide() {
            return this.side;
        }

        public String getIssuingCountry() {
            return this.issuingCountry;
        }

        public Boolean getValidateImageQuality() {
            return this.validateImageQuality;
        }

        public Location.Request getLocation() {
            return this.location;
        }
    }
}

