/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.models;

import com.onfido.api.ApiJson;
import com.squareup.moshi.Json;
import java.util.Objects;

public final class DocumentClassification {
    private static final ApiJson<DocumentClassification> JSON = new ApiJson<DocumentClassification>(DocumentClassification.class);
    @Json(name="issuing_country")
    private final String issuingCountry;
    @Json(name="document_type")
    private final String documentType;
    @Json(name="issuing_state")
    private final String issuingState;
    @Json(name="subtype")
    private final String subtype;
    @Json(name="version")
    private final String version;

    private DocumentClassification() {
        this.issuingCountry = null;
        this.documentType = null;
        this.issuingState = null;
        this.subtype = null;
        this.version = null;
    }

    public static Request request() {
        return new Request();
    }

    public String getIssuingCountry() {
        return this.issuingCountry;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public String getIssuingState() {
        return this.issuingState;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return "DocumentClassification " + JSON.toPrettyJson(this);
    }

    public int hashCode() {
        return Objects.hash(this.issuingCountry, this.documentType, this.issuingState, this.subtype, this.version, "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentClassification other = (DocumentClassification)o;
        return Objects.equals(this.issuingCountry, other.issuingCountry) && Objects.equals(this.documentType, other.documentType) && Objects.equals(this.issuingState, other.issuingState) && Objects.equals(this.subtype, other.subtype) && Objects.equals(this.version, other.version);
    }

    public static final class Request {
        private static final ApiJson<Request> REQUEST_JSON = new ApiJson<Request>(Request.class);

        private Request() {
        }

        public String toJson() {
            return REQUEST_JSON.toJson(this);
        }

        public String toString() {
            return this.toJson();
        }
    }
}

