/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.models;

import com.onfido.api.ApiJson;
import com.squareup.moshi.Json;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class LiveVideo {
    private static final ApiJson<LiveVideo> JSON = new ApiJson<LiveVideo>(LiveVideo.class);
    @Json(name="id")
    private final String id;
    @Json(name="created_at")
    private final OffsetDateTime createdAt = null;
    @Json(name="href")
    private final String href;
    @Json(name="download_href")
    private final String downloadHref;
    @Json(name="file_name")
    private final String fileName;
    @Json(name="file_size")
    private final int fileSize;
    @Json(name="file_type")
    private final String fileType;
    @Json(name="challenge")
    private final List<Map<String, Object>> challenge = null;

    private LiveVideo() {
        this.id = null;
        this.href = null;
        this.downloadHref = null;
        this.fileName = null;
        this.fileSize = 0;
        this.fileType = null;
    }

    public static Request request() {
        return new Request();
    }

    public String getId() {
        return this.id;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getHref() {
        return this.href;
    }

    public String getDownloadHref() {
        return this.downloadHref;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public String getFileType() {
        return this.fileType;
    }

    public List<Map<String, Object>> getChallenge() {
        return this.challenge;
    }

    public String toString() {
        return "LiveVideo " + JSON.toPrettyJson(this);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.href, this.downloadHref, this.fileName, this.fileSize, this.fileType, this.challenge, "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveVideo other = (LiveVideo)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.href, other.href) && Objects.equals(this.downloadHref, other.downloadHref) && Objects.equals(this.fileName, other.fileName) && Objects.equals(this.fileSize, other.fileSize) && Objects.equals(this.fileType, other.fileType) && Objects.equals(this.challenge, other.challenge);
    }

    public static final class Request {
        private static final ApiJson<Request> REQUEST_JSON = new ApiJson<Request>(Request.class);

        private Request() {
        }

        public String toJson() {
            return REQUEST_JSON.toJson(this);
        }

        public String toString() {
            return this.toJson();
        }
    }
}

