/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.models;

import com.onfido.api.ApiJson;
import com.squareup.moshi.Json;
import java.util.Objects;

public final class Location {
    private static final ApiJson<Location> JSON = new ApiJson<Location>(Location.class);
    @Json(name="ip_address")
    private final String ipAddress;
    @Json(name="country_of_residence")
    private final String countryOfResidence;

    private Location() {
        this.ipAddress = null;
        this.countryOfResidence = null;
    }

    public static Request request() {
        return new Request();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getCountryOfResidence() {
        return this.countryOfResidence;
    }

    public String toString() {
        return "Location " + JSON.toPrettyJson(this);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.countryOfResidence, "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location other = (Location)o;
        return Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.countryOfResidence, other.countryOfResidence);
    }

    public static final class Request {
        private static final ApiJson<Request> REQUEST_JSON = new ApiJson<Request>(Request.class);
        @Json(name="ip_address")
        private String ipAddress;
        @Json(name="country_of_residence")
        private String countryOfResidence;

        private Request() {
        }

        public String toJson() {
            return REQUEST_JSON.toJson(this);
        }

        public String toString() {
            return this.toJson();
        }

        public Request ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Request countryOfResidence(String countryOfResidence) {
            this.countryOfResidence = countryOfResidence;
            return this;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getCountryOfResidence() {
            return this.countryOfResidence;
        }
    }
}

