/*
 * Decompiled with CFR 0.152.
 */
package com.onfido.models;

import com.onfido.api.ApiJson;
import com.squareup.moshi.Json;
import java.util.List;
import java.util.Objects;

public final class Webhook {
    private static final ApiJson<Webhook> JSON = new ApiJson<Webhook>(Webhook.class);
    @Json(name="id")
    private final String id;
    @Json(name="url")
    private final String url;
    @Json(name="enabled")
    private final boolean enabled;
    @Json(name="events")
    private final List<String> events = null;
    @Json(name="token")
    private final String token;
    @Json(name="href")
    private final String href;
    @Json(name="environments")
    private final List<String> environments = null;

    private Webhook() {
        this.id = null;
        this.url = null;
        this.enabled = false;
        this.token = null;
        this.href = null;
    }

    public static Request request() {
        return new Request();
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public String getToken() {
        return this.token;
    }

    public String getHref() {
        return this.href;
    }

    public List<String> getEnvironments() {
        return this.environments;
    }

    public String toString() {
        return "Webhook " + JSON.toPrettyJson(this);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.url, this.enabled, this.events, this.token, this.href, this.environments, "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook other = (Webhook)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.url, other.url) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.events, other.events) && Objects.equals(this.token, other.token) && Objects.equals(this.href, other.href) && Objects.equals(this.environments, other.environments);
    }

    public static final class Request {
        private static final ApiJson<Request> REQUEST_JSON = new ApiJson<Request>(Request.class);
        @Json(name="url")
        private String url;
        @Json(name="enabled")
        private Boolean enabled;
        @Json(name="events")
        private String[] events;
        @Json(name="environments")
        private String[] environments;

        private Request() {
        }

        public String toJson() {
            return REQUEST_JSON.toJson(this);
        }

        public String toString() {
            return this.toJson();
        }

        public Request url(String url) {
            this.url = url;
            return this;
        }

        public Request enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Request events(List<String> events) {
            this.events = events.toArray(new String[0]);
            return this;
        }

        public Request events(String ... events) {
            this.events = events;
            return this;
        }

        public Request environments(List<String> environments) {
            this.environments = environments.toArray(new String[0]);
            return this;
        }

        public Request environments(String ... environments) {
            this.environments = environments;
            return this;
        }

        public String getUrl() {
            return this.url;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public String[] getEvents() {
            return this.events;
        }

        public String[] getEnvironments() {
            return this.environments;
        }
    }
}

