/*
 * Decompiled with CFR 0.152.
 */
package com.openai.core;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/openai/core/LenientLocalDateTimeDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Ljava/time/LocalDateTime;", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "logicalType", "Lcom/fasterxml/jackson/databind/type/LogicalType;", "Companion", "openai-java-core"})
@SourceDebugExtension(value={"SMAP\nObjectMappers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectMappers.kt\ncom/openai/core/LenientLocalDateTimeDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1855#2,2:169\n*S KotlinDebug\n*F\n+ 1 ObjectMappers.kt\ncom/openai/core/LenientLocalDateTimeDeserializer\n*L\n164#1:169,2\n*E\n"})
final class LenientLocalDateTimeDeserializer
extends StdDeserializer<LocalDateTime> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<DateTimeFormatter> DATE_TIME_FORMATTERS;

    public LenientLocalDateTimeDeserializer() {
        super(LocalDateTime.class);
    }

    @NotNull
    public LogicalType logicalType() {
        return LogicalType.DateTime;
    }

    @NotNull
    public LocalDateTime deserialize(@NotNull JsonParser p, @Nullable DeserializationContext context) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        List exceptions = new ArrayList();
        JsonParseException jsonParseException = DATE_TIME_FORMATTERS.iterator();
        while (jsonParseException.hasNext()) {
            DateTimeFormatter formatter = jsonParseException.next();
            try {
                LocalDateTime localDateTime;
                TemporalAccessor temporal = formatter.parse(p.getText());
                if (!temporal.isSupported(ChronoField.HOUR_OF_DAY)) {
                    LocalDateTime localDateTime2 = LocalDate.from(temporal).atStartOfDay();
                    localDateTime = localDateTime2;
                    Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"from(temporal).atStartOfDay()");
                } else if (!temporal.isSupported(ChronoField.OFFSET_SECONDS)) {
                    LocalDateTime localDateTime3 = LocalDateTime.from(temporal);
                    localDateTime = localDateTime3;
                    Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"from(temporal)");
                } else {
                    LocalDateTime localDateTime4 = ZonedDateTime.from(temporal).toLocalDateTime();
                    localDateTime = localDateTime4;
                    Intrinsics.checkNotNullExpressionValue((Object)localDateTime4, (String)"from(temporal).toLocalDateTime()");
                }
                return localDateTime;
            }
            catch (DateTimeException e) {
                exceptions.add(e);
            }
        }
        JsonParseException $this$deserialize_u24lambda_u241 = jsonParseException = new JsonParseException(p, "Cannot parse `LocalDateTime` from value: " + p.getText());
        boolean bl = false;
        Iterable $this$forEach$iv = exceptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Exception it = (Exception)element$iv;
            boolean bl2 = false;
            ExceptionsKt.addSuppressed((Throwable)((Throwable)$this$deserialize_u24lambda_u241), (Throwable)it);
        }
        throw (Throwable)jsonParseException;
    }

    static {
        Object[] objectArray = new DateTimeFormatter[]{DateTimeFormatter.ISO_LOCAL_DATE_TIME, DateTimeFormatter.ISO_LOCAL_DATE, DateTimeFormatter.ISO_ZONED_DATE_TIME};
        DATE_TIME_FORMATTERS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/openai/core/LenientLocalDateTimeDeserializer$Companion;", "", "()V", "DATE_TIME_FORMATTERS", "", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "openai-java-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

