/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.conversion.impl;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.conversion.NullHandler;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionContextState;
import com.opensymphony.xwork2.util.reflection.ReflectionProvider;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class InstantiatingNullHandler
implements NullHandler {
    public static final String CREATE_NULL_OBJECTS = "xwork.NullHandler.createNullObjects";
    private static final Logger LOG = LoggerFactory.getLogger(InstantiatingNullHandler.class);
    private ReflectionProvider reflectionProvider;
    private ObjectFactory objectFactory;

    @Inject
    public void setReflectionProvider(ReflectionProvider prov) {
        this.reflectionProvider = prov;
    }

    @Inject
    public void setObjectFactory(ObjectFactory fac) {
        this.objectFactory = fac;
    }

    public Object nullMethodResult(Map context, Object target, String methodName, Object[] args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering nullMethodResult ", new String[0]);
        }
        return null;
    }

    public Object nullPropertyValue(Map context, Object target, Object property) {
        boolean c;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering nullPropertyValue [target=" + target + ", property=" + property + "]", new String[0]);
        }
        if (!(c = ReflectionContextState.isCreatingNullObjects(context))) {
            return null;
        }
        if (target == null || property == null) {
            return null;
        }
        try {
            String propName = property.toString();
            Object realTarget = this.reflectionProvider.getRealTarget(propName, context, target);
            Class<?> clazz = null;
            if (realTarget != null) {
                PropertyDescriptor pd = this.reflectionProvider.getPropertyDescriptor(realTarget.getClass(), propName);
                if (pd == null) {
                    return null;
                }
                clazz = pd.getPropertyType();
            }
            if (clazz == null) {
                return null;
            }
            Object param = this.createObject(clazz, realTarget, propName, context);
            this.reflectionProvider.setValue(propName, context, realTarget, param);
            return param;
        }
        catch (Exception e) {
            LOG.error("Could not create and/or set value back on to object", e, new String[0]);
            return null;
        }
    }

    private Object createObject(Class clazz, Object target, String property, Map context) throws Exception {
        if (Collection.class.isAssignableFrom(clazz)) {
            return new ArrayList();
        }
        if (clazz == Map.class) {
            return new HashMap();
        }
        return this.objectFactory.buildBean(clazz, context);
    }
}

