/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Locale;
import java.util.Map;

public class I18nInterceptor
extends AbstractInterceptor {
    protected static final Logger LOG = LoggerFactory.getLogger(I18nInterceptor.class);
    public static final String DEFAULT_SESSION_ATTRIBUTE = "WW_TRANS_I18N_LOCALE";
    public static final String DEFAULT_PARAMETER = "request_locale";
    protected String parameterName = "request_locale";
    protected String attributeName = "WW_TRANS_I18N_LOCALE";

    public I18nInterceptor() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("new I18nInterceptor()", new String[0]);
        }
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Map session;
        Map params;
        Object requested_locale;
        if (LOG.isDebugEnabled()) {
            LOG.debug("intercept '" + invocation.getProxy().getNamespace() + "/" + invocation.getProxy().getActionName() + "' { ", new String[0]);
        }
        if ((requested_locale = (params = invocation.getInvocationContext().getParameters()).remove(this.parameterName)) != null && requested_locale.getClass().isArray() && ((Object[])requested_locale).length == 1) {
            requested_locale = ((Object[])requested_locale)[0];
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("requested_locale=" + requested_locale, new String[0]);
        }
        if ((session = invocation.getInvocationContext().getSession()) != null) {
            Object locale;
            if (requested_locale != null) {
                Locale locale2 = locale = requested_locale instanceof Locale ? (Locale)requested_locale : LocalizedTextUtil.localeFromString(requested_locale.toString(), null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("store locale=" + locale, new String[0]);
                }
                if (locale != null) {
                    session.put(this.attributeName, locale);
                }
            }
            if ((locale = session.get(this.attributeName)) != null && locale instanceof Locale) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("apply locale=" + locale, new String[0]);
                }
                this.saveLocale(invocation, (Locale)locale);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("before Locale=" + invocation.getStack().findValue("locale"), new String[0]);
        }
        String result = invocation.invoke();
        if (LOG.isDebugEnabled()) {
            LOG.debug("after Locale=" + invocation.getStack().findValue("locale"), new String[0]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("intercept } ", new String[0]);
        }
        return result;
    }

    protected void saveLocale(ActionInvocation invocation, Locale locale) {
        invocation.getInvocationContext().setLocale(locale);
    }
}

