/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ParameterFilterInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ParameterFilterInterceptor.class);
    private Collection allowed;
    private Collection blocked;
    private Map includesExcludesMap;
    private boolean defaultBlock = false;

    public String intercept(ActionInvocation invocation) throws Exception {
        Map parameters = invocation.getInvocationContext().getParameters();
        HashSet<String> paramsToRemove = new HashSet<String>();
        Map includesExcludesMap = this.getIncludesExcludesMap();
        for (String param : parameters.keySet()) {
            boolean currentAllowed = !this.isDefaultBlock();
            boolean foundApplicableRule = false;
            for (String currRule : includesExcludesMap.keySet()) {
                if (param.startsWith(currRule) && (param.length() == currRule.length() || ParameterFilterInterceptor.isPropSeperator(param.charAt(currRule.length())))) {
                    currentAllowed = (Boolean)includesExcludesMap.get(currRule);
                    continue;
                }
                if (!foundApplicableRule) continue;
                foundApplicableRule = false;
                break;
            }
            if (currentAllowed) continue;
            paramsToRemove.add(param);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Params to remove: " + paramsToRemove, new String[0]);
        }
        Iterator<Object> i = paramsToRemove.iterator();
        while (i.hasNext()) {
            parameters.remove(i.next());
        }
        return invocation.invoke();
    }

    private static boolean isPropSeperator(char c) {
        return c == '.' || c == '(' || c == '[';
    }

    private Map getIncludesExcludesMap() {
        if (this.includesExcludesMap == null) {
            Iterator i;
            this.includesExcludesMap = new TreeMap();
            if (this.getAllowedCollection() != null) {
                i = this.getAllowedCollection().iterator();
                while (i.hasNext()) {
                    this.includesExcludesMap.put(i.next(), Boolean.TRUE);
                }
            }
            if (this.getBlockedCollection() != null) {
                i = this.getBlockedCollection().iterator();
                while (i.hasNext()) {
                    this.includesExcludesMap.put(i.next(), Boolean.FALSE);
                }
            }
        }
        return this.includesExcludesMap;
    }

    public boolean isDefaultBlock() {
        return this.defaultBlock;
    }

    public void setDefaultBlock(boolean defaultExclude) {
        this.defaultBlock = defaultExclude;
    }

    public Collection getBlockedCollection() {
        return this.blocked;
    }

    public void setBlockedCollection(Collection blocked) {
        this.blocked = blocked;
    }

    public void setBlocked(String blocked) {
        this.setBlockedCollection(this.asCollection(blocked));
    }

    public Collection getAllowedCollection() {
        return this.allowed;
    }

    public void setAllowedCollection(Collection allowed) {
        this.allowed = allowed;
    }

    public void setAllowed(String allowed) {
        this.setAllowedCollection(this.asCollection(allowed));
    }

    private Collection asCollection(String commaDelim) {
        if (commaDelim == null || commaDelim.trim().length() == 0) {
            return null;
        }
        return TextParseUtil.commaDelimitedStringToSet(commaDelim);
    }
}

