/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.Parameterizable;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Map;

public class StaticParametersInterceptor
extends AbstractInterceptor {
    private boolean parse;
    private static final Logger LOG = LoggerFactory.getLogger(StaticParametersInterceptor.class);

    public void setParse(String value) {
        this.parse = Boolean.valueOf(value);
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        ActionConfig config = invocation.getProxy().getConfig();
        Object action = invocation.getAction();
        Map<String, Object> parameters = config.getParams();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting static parameters " + parameters, new String[0]);
        }
        if (action instanceof Parameterizable) {
            ((Parameterizable)action).setParams(parameters);
        }
        if (parameters != null) {
            ValueStack stack = ActionContext.getContext().getValueStack();
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                stack.setValue(entry.getKey().toString(), entry.getValue());
                Object val = entry.getValue();
                if (this.parse && val instanceof String) {
                    val = TextParseUtil.translateVariables((String)val, stack);
                }
                stack.setValue(entry.getKey().toString(), val);
            }
        }
        return invocation.invoke();
    }
}

