/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.extensible.AbstractExtensible;
import com.oracle.bedrock.options.Diagnostics;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.ApplicationConsoleBuilder;
import com.oracle.bedrock.runtime.ApplicationListener;
import com.oracle.bedrock.runtime.ApplicationProcess;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.console.InputRedirector;
import com.oracle.bedrock.runtime.console.OutputRedirector;
import com.oracle.bedrock.runtime.options.ApplicationClosingBehavior;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.runtime.options.ConsoleErrorRedirector;
import com.oracle.bedrock.runtime.options.ConsoleInputRedirector;
import com.oracle.bedrock.runtime.options.ConsoleOutputRedirector;
import com.oracle.bedrock.runtime.options.DisplayName;
import java.util.concurrent.atomic.AtomicBoolean;

@Internal
public abstract class AbstractApplication<P extends ApplicationProcess>
extends AbstractExtensible
implements Application {
    protected final Platform platform;
    protected final String displayName;
    protected final P process;
    protected final OptionsByType optionsByType;
    protected final ApplicationConsole console;
    private final OutputRedirector stdoutThread;
    private final OutputRedirector stderrThread;
    private final InputRedirector stdinThread;
    private Timeout defaultTimeout;
    private AtomicBoolean closed;

    public AbstractApplication(Platform platform, P process, OptionsByType optionsByType) {
        this.platform = platform;
        this.process = process;
        this.optionsByType = optionsByType;
        this.closed = new AtomicBoolean(false);
        this.defaultTimeout = (Timeout)optionsByType.get(Timeout.class, new Object[0]);
        boolean diagnosticsEnabled = ((Diagnostics)optionsByType.get(Diagnostics.class, new Object[0])).isEnabled();
        this.displayName = ((DisplayName)optionsByType.get(DisplayName.class, new Object[0])).resolve(optionsByType);
        this.console = ((ApplicationConsoleBuilder)optionsByType.getOrSetDefault(ApplicationConsoleBuilder.class, (Option)Console.system())).build(this.displayName);
        ConsoleOutputRedirector outputRedirector = (ConsoleOutputRedirector)optionsByType.getOrDefault(ConsoleOutputRedirector.class, (Option)ConsoleOutputRedirector.defaultRedirector());
        this.stdoutThread = outputRedirector.getRedirector();
        this.stdoutThread.setName(this.displayName + " StdOut Thread");
        this.stdoutThread.start(this.displayName, "out", process.getInputStream(), this.console, process.getId(), diagnosticsEnabled);
        ConsoleErrorRedirector errorRedirector = (ConsoleErrorRedirector)optionsByType.getOrDefault(ConsoleErrorRedirector.class, (Option)ConsoleErrorRedirector.defaultRedirector());
        this.stderrThread = errorRedirector.getRedirector();
        this.stderrThread.setName(this.displayName + " StdErr Thread");
        this.stderrThread.start(this.displayName, "err", process.getErrorStream(), this.console, process.getId(), diagnosticsEnabled);
        ConsoleInputRedirector inRedirector = (ConsoleInputRedirector)optionsByType.getOrDefault(ConsoleInputRedirector.class, (Option)ConsoleInputRedirector.defaultRedirector());
        this.stdinThread = inRedirector.getRedirector();
        this.stdinThread.setName(this.displayName + " StdIn Thread");
        this.stdinThread.start(process.getOutputStream(), this.console);
    }

    @Override
    public Timeout getDefaultTimeout() {
        return this.defaultTimeout;
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public OptionsByType getOptions() {
        return this.optionsByType;
    }

    @Override
    public boolean isOperational() {
        return !this.closed.get();
    }

    @Override
    public void close() {
        this.close(new Option[0]);
    }

    @Override
    public void close(Option ... options) {
        if (this.closed.compareAndSet(false, true)) {
            OptionsByType closingOptions = OptionsByType.of((Option[])options);
            for (ApplicationListener listener : this.getInstancesOf(ApplicationListener.class)) {
                listener.onClosing(this, closingOptions);
            }
            for (Profile profile : this.getOptions().getInstancesOf(Profile.class)) {
                profile.onClosing(this.platform, this, this.getOptions());
            }
            for (ApplicationListener listener : this.getOptions().getInstancesOf(ApplicationListener.class)) {
                listener.onClosing(this, closingOptions);
            }
            ApplicationClosingBehavior defaultClosingBehavior = (ApplicationClosingBehavior)this.getOptions().get(ApplicationClosingBehavior.class, new Object[0]);
            ApplicationClosingBehavior closingBehavior = (ApplicationClosingBehavior)closingOptions.getOrDefault(ApplicationClosingBehavior.class, (Option)defaultClosingBehavior);
            if (closingBehavior != null) {
                try {
                    closingBehavior.onBeforeClosing(this, options);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.process.close();
            try {
                this.stdinThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.stdoutThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.stdoutThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.stderrThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.stderrThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.console.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.waitFor(options);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            for (ApplicationListener listener : this.getOptions().getInstancesOf(ApplicationListener.class)) {
                listener.onClosed(this, closingOptions);
            }
            for (ApplicationListener listener : this.getInstancesOf(ApplicationListener.class)) {
                listener.onClosed(this, closingOptions);
            }
            this.removeAllFeatures();
        }
    }

    @Override
    public long getId() {
        return this.process.getId();
    }

    @Override
    public int waitFor(Option ... options) {
        OptionsByType waitForOptions = OptionsByType.of((Option[])this.getOptions().asArray()).addAll(options);
        return this.process.waitFor(waitForOptions.asArray());
    }

    @Override
    public int exitValue() {
        return this.process.exitValue();
    }
}

